/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.solublesalts.view;

import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.solublesalts.SolubleSaltResources;
import edu.colorado.phet.solublesalts.SolubleSaltsConfig;
import edu.colorado.phet.solublesalts.model.Vessel;
import edu.colorado.phet.solublesalts.module.SolubleSaltsModule;
import edu.colorado.phet.solublesalts.util.ScientificNotation;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class VesselGraphic
extends PNode
implements SolubleSaltsModule.ResetListener {
    private PPath shape;
    private PPath water;
    private Color waterColor = SolubleSaltsConfig.WATER_COLOR;
    private Vessel vessel;
    private Color tickColor = new Color(255, 180, 180);
    private ArrayList minorTicks = new ArrayList();
    private ArrayList majorTicks = new ArrayList();
    private final SolubleSaltsModule module;

    public VesselGraphic(Vessel vessel, SolubleSaltsModule solubleSaltsModule) {
        this.module = solubleSaltsModule;
        solubleSaltsModule.addResetListener(this);
        this.vessel = vessel;
        vessel.addChangeListener(new Vessel.ChangeListener(){

            public void stateChanged(Vessel.ChangeEvent changeEvent) {
                VesselGraphic.this.update(changeEvent.getVessel());
            }
        });
        this.shape = new PPath();
        this.addChild(this.shape);
        this.water = new PPath();
        this.water.setPaint(this.waterColor);
        this.water.setStrokePaint(null);
        this.addChild(this.water);
        this.setMinorTickSpacing(solubleSaltsModule.getCalibration());
        this.setMajorTickSpacing(solubleSaltsModule.getCalibration());
        this.update(vessel);
    }

    private void update(Vessel vessel) {
        this.vessel = vessel;
        float f = (float)(vessel.getWallThickness() * 1.0);
        Rectangle2D rectangle2D = vessel.getShape();
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath();
        doubleGeneralPath.moveTo(-f / 2.0f, 0.0);
        doubleGeneralPath.lineToRelative(0.0, rectangle2D.getHeight() + (double)(f / 2.0f));
        doubleGeneralPath.lineToRelative(rectangle2D.getWidth() + (double)f, 0.0);
        doubleGeneralPath.lineToRelative(0.0, -(rectangle2D.getHeight() + (double)(f / 2.0f)));
        this.shape.setPathTo(doubleGeneralPath.getGeneralPath());
        this.shape.setStroke(new BasicStroke(f));
        this.water.setPathTo(new Rectangle2D.Double(0.0, this.shape.getHeight() - (double)(f * 3.0f / 2.0f) - vessel.getWaterLevel(), vessel.getShape().getWidth(), vessel.getWaterLevel()));
        this.setOffset(vessel.getLocation());
    }

    public void setMajorTickSpacing(SolubleSaltsConfig.Calibration calibration) {
        int n;
        for (n = 0; n < this.majorTicks.size(); ++n) {
            PNode pNode = (PNode)this.majorTicks.get(n);
            this.removeChild(pNode);
        }
        this.majorTicks.clear();
        n = (int)(this.vessel.getDepth() / (calibration.majorTickSpacing / calibration.volumeCalibrationFactor));
        for (int i = 1; i <= n; ++i) {
            double d = this.vessel.getDepth() - (double)i * (calibration.majorTickSpacing / calibration.volumeCalibrationFactor);
            PPath pPath = new PPath(new Line2D.Double(this.vessel.getWidth() + 2.0, d, this.vessel.getWidth() + this.vessel.getWallThickness() / 2.0, d));
            pPath.setStroke(new BasicStroke(2.0f));
            pPath.setStrokePaint(this.tickColor);
            pPath.setPaint(this.tickColor);
            this.addChild(pPath);
            double d2 = (this.vessel.getDepth() - d) * calibration.volumeCalibrationFactor;
            String string = ScientificNotation.toHtml(d2, 1, "", SolubleSaltResources.getString("ControlLabels.liters.abbreviation"));
            HTMLNode hTMLNode = new HTMLNode(string);
            this.module.updateHTMLNode(hTMLNode);
            Font font = hTMLNode.getFont();
            Font font2 = new Font(font.getName(), 0, font.getSize() + 12);
            hTMLNode.setFont(font2);
            hTMLNode.setOffset(this.vessel.getWidth() + this.vessel.getWallThickness() + 5.0, d - 25.0);
            this.addChild(hTMLNode);
            this.minorTicks.add(pPath);
            this.minorTicks.add(hTMLNode);
        }
    }

    public void setMinorTickSpacing(SolubleSaltsConfig.Calibration calibration) {
        int n;
        for (n = 0; n < this.minorTicks.size(); ++n) {
            PNode pNode = (PNode)this.minorTicks.get(n);
            this.removeChild(pNode);
        }
        this.minorTicks.clear();
        n = (int)(this.vessel.getDepth() / (calibration.minorTickSpacing / calibration.volumeCalibrationFactor));
        for (int i = 1; i <= n; ++i) {
            double d = this.vessel.getDepth() - (double)i * (calibration.minorTickSpacing / calibration.volumeCalibrationFactor);
            PPath pPath = new PPath(new Line2D.Double(this.vessel.getWidth() + 2.0, d, this.vessel.getWidth() + this.vessel.getWallThickness() / 4.0, d));
            pPath.setStroke(new BasicStroke(2.0f));
            pPath.setStrokePaint(this.tickColor);
            pPath.setPaint(this.tickColor);
            this.addChild(pPath);
            this.minorTicks.add(pPath);
        }
    }

    public void reset(SolubleSaltsConfig.Calibration calibration) {
        this.setMinorTickSpacing(calibration);
        this.setMajorTickSpacing(calibration);
        this.update(this.vessel);
    }
}

