/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.solublesalts.view;

import edu.colorado.phet.solublesalts.model.ion.Arsenate;
import edu.colorado.phet.solublesalts.model.ion.Bromine;
import edu.colorado.phet.solublesalts.model.ion.Chlorine;
import edu.colorado.phet.solublesalts.model.ion.Chromium;
import edu.colorado.phet.solublesalts.model.ion.ConfigurableAnion;
import edu.colorado.phet.solublesalts.model.ion.ConfigurableCation;
import edu.colorado.phet.solublesalts.model.ion.Copper;
import edu.colorado.phet.solublesalts.model.ion.Hydroxide;
import edu.colorado.phet.solublesalts.model.ion.Iodide;
import edu.colorado.phet.solublesalts.model.ion.Ion;
import edu.colorado.phet.solublesalts.model.ion.IonEvent;
import edu.colorado.phet.solublesalts.model.ion.IonListener;
import edu.colorado.phet.solublesalts.model.ion.Lead;
import edu.colorado.phet.solublesalts.model.ion.Mercury;
import edu.colorado.phet.solublesalts.model.ion.Phosphate;
import edu.colorado.phet.solublesalts.model.ion.Silver;
import edu.colorado.phet.solublesalts.model.ion.Sodium;
import edu.colorado.phet.solublesalts.model.ion.Strontium;
import edu.colorado.phet.solublesalts.model.ion.Sulfur;
import edu.colorado.phet.solublesalts.model.ion.Thallium;
import edu.colorado.phet.solublesalts.view.IonGraphic;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.HashMap;

public class IonGraphicManager
implements IonListener {
    private static HashMap<Class, BufferedImage> imageMap = new HashMap();
    private PNode graphicContainer;
    private HashMap ionToGraphicMap = new HashMap();

    public static BufferedImage getIonImage(Class clazz) {
        BufferedImage bufferedImage = imageMap.get(clazz);
        if (bufferedImage == null) {
            throw new RuntimeException("Ion class not recognized");
        }
        return imageMap.get(clazz);
    }

    public static void putImage(Ion ion, Color color) {
        IonGraphic ionGraphic = new IonGraphic(ion, "soluble-salts/images/molecule-big.gif");
        if (color == null) {
            throw new RuntimeException("Ion class not recognized");
        }
        ionGraphic.setColor(color);
        IonGraphicManager.putImage(ion.getClass(), (BufferedImage)ionGraphic.getImage());
    }

    public static void putImage(Class clazz, BufferedImage bufferedImage) {
        imageMap.put(clazz, bufferedImage);
    }

    protected IonGraphic createPImage(Ion ion) {
        BufferedImage bufferedImage = imageMap.get(ion.getClass());
        return this.createImage(ion, bufferedImage);
    }

    protected IonGraphic createImage(Ion ion, BufferedImage bufferedImage) {
        return new IonGraphic(ion, bufferedImage);
    }

    public IonGraphicManager(PNode pNode) {
        this.graphicContainer = pNode;
    }

    public void ionAdded(IonEvent ionEvent) {
        IonGraphic ionGraphic = this.createPImage(ionEvent.getIon());
        this.graphicContainer.addChild(ionGraphic);
        this.ionToGraphicMap.put(ionEvent.getIon(), ionGraphic);
    }

    public void ionRemoved(IonEvent ionEvent) {
        IonGraphic ionGraphic = (IonGraphic)this.ionToGraphicMap.get(ionEvent.getIon());
        if (ionGraphic != null) {
            this.graphicContainer.removeChild(ionGraphic);
            this.ionToGraphicMap.remove(ionEvent.getIon());
        }
    }

    static {
        IonGraphicManager.putImage(new ConfigurableCation(), new Color(0, 0, 0));
        IonGraphicManager.putImage(new ConfigurableAnion(), new Color(230, 230, 230));
        IonGraphicManager.putImage(new Sodium(), new Color(200, 0, 60));
        IonGraphicManager.putImage(new Chlorine(), new Color(0, 100, 0));
        IonGraphicManager.putImage(new Lead(), Color.red);
        IonGraphicManager.putImage(new Silver(), Color.black);
        IonGraphicManager.putImage(new Iodide(), new Color(140, 10, 10));
        IonGraphicManager.putImage(new Copper(), new Color(4, 110, 40));
        IonGraphicManager.putImage(new Hydroxide(), new Color(255, 90, 13));
        IonGraphicManager.putImage(new Chromium(), Color.black);
        IonGraphicManager.putImage(new Strontium(), new Color(220, 0, 160));
        IonGraphicManager.putImage(new Phosphate(), new Color(20, 140, 30));
        IonGraphicManager.putImage(new Bromine(), new Color(120, 100, 60));
        IonGraphicManager.putImage(new Mercury(), new Color(160, 80, 210));
        IonGraphicManager.putImage(new Thallium(), new Color(180, 0, 220));
        IonGraphicManager.putImage(new Sulfur(), new Color(255, 255, 0));
        IonGraphicManager.putImage(new Arsenate(), new Color(255, 90, 13));
    }
}

