/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.solublesalts.view;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.MakeDuotoneImageOp;
import edu.colorado.phet.common.piccolophet.util.PImageFactory;
import edu.colorado.phet.solublesalts.model.ion.Ion;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

public class IonGraphic
extends PNode
implements SimpleObserver {
    private static boolean showBondIndicators = false;
    private Ion ion;
    protected PImage pImage;
    private PText pText;
    private PPath pDebugPath;

    public static void showBondIndicators(boolean bl) {
        showBondIndicators = bl;
    }

    public IonGraphic(Ion ion, String string) {
        this.pImage = PImageFactory.create(string, new Dimension((int)ion.getRadius() * 2, (int)ion.getRadius() * 2));
        this.init(ion);
    }

    public IonGraphic(Ion ion, BufferedImage bufferedImage) {
        this.pImage = new PImage(bufferedImage);
        this.init(ion);
    }

    private void init(Ion ion) {
        this.setPickable(false);
        this.ion = ion;
        ion.addObserver(this);
        this.addChild(this.pImage);
        String string = ion.getCharge() < 0.0 ? "-" : (ion.getCharge() > 0.0 ? "+" : "0");
        this.pText = new PText(string);
        this.pText.setTextPaint(Color.white);
        this.pText.setTextPaint(Color.black);
        Font font = this.pText.getFont();
        Font font2 = new Font(font.getName(), font.getStyle(), font.getSize() + 2);
        this.pText.setFont(font2);
        this.pText.setX(this.pImage.getWidth() * 1.0 / 2.0 - (double)(font.getSize() / 2));
        this.update();
    }

    public void update() {
        this.updateOffset(this.ion.getPosition());
        if (showBondIndicators && this.ion.isBound()) {
            if (this.pDebugPath == null) {
                this.pDebugPath = new PPath(new Ellipse2D.Double(this.pImage.getWidth() / 2.0 - 2.0, this.pImage.getHeight() / 2.0 - 2.0, 4.0, 4.0));
                this.addChild(this.pDebugPath);
            }
            Color color = Color.red;
            if (this.ion.getBindingCrystal().getSeed() == this.ion) {
                color = Color.green;
            }
            this.pDebugPath.setPaint(color);
            this.pDebugPath.setStrokePaint(color);
        } else if (!this.ion.isBound() && this.pDebugPath != null) {
            this.removeChild(this.pDebugPath);
            this.pDebugPath = null;
        }
    }

    protected void updateOffset(Point2D point2D) {
        this.setOffset(point2D.getX() - this.pImage.getWidth() / 2.0, point2D.getY() - this.pImage.getHeight() / 2.0);
    }

    public void setColor(Color color) {
        MakeDuotoneImageOp makeDuotoneImageOp = new MakeDuotoneImageOp(color);
        this.pImage.setImage(makeDuotoneImageOp.filter((BufferedImage)this.pImage.getImage(), null));
    }

    public Image getImage() {
        return this.pImage.getImage();
    }
}

