/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.solublesalts.module;

import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.common.piccolophet.PiccoloModule;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.solublesalts.SolubleSaltsConfig;
import edu.colorado.phet.solublesalts.model.IonInitializer;
import edu.colorado.phet.solublesalts.model.SolubleSaltsModel;
import edu.colorado.phet.solublesalts.model.crystal.Bond;
import edu.colorado.phet.solublesalts.model.ion.Chlorine;
import edu.colorado.phet.solublesalts.model.ion.Ion;
import edu.colorado.phet.solublesalts.model.ion.Sodium;
import edu.colorado.phet.solublesalts.module.ISolubleSaltsModelContainer;
import edu.colorado.phet.solublesalts.view.BondGraphic;
import edu.colorado.phet.solublesalts.view.IonGraphicManager;
import edu.colorado.phet.solublesalts.view.SolubleSaltsCanvas;
import edu.colorado.phet.solublesalts.view.WorldNode;
import java.awt.Dimension;
import java.util.EventListener;
import java.util.HashMap;

public class SolubleSaltsModule
extends PiccoloModule
implements ISolubleSaltsModelContainer {
    boolean debug = false;
    private SolubleSaltsCanvas canvas;
    private SolubleSaltsConfig.Calibration calibration;
    private WorldNode fullScaleCanvas;
    private final SolubleSaltsModel solubleSaltsModel;
    private EventChannel resetEventChannel = new EventChannel(ResetListener.class);
    private ResetListener resetListenerProxy = (ResetListener)this.resetEventChannel.getListenerProxy();

    public SolubleSaltsModule(String string, IClock iClock, SolubleSaltsConfig.Calibration calibration) {
        super(string, iClock);
        this.setCalibration(calibration);
        this.solubleSaltsModel = new SolubleSaltsModel(iClock, this);
        this.setModel(this.solubleSaltsModel);
        this.canvas = new SolubleSaltsCanvas(new Dimension((int)(this.solubleSaltsModel.getBounds().getWidth() * 0.1), (int)(this.solubleSaltsModel.getBounds().getHeight() * 0.1)));
        this.setSimulationPanel(this.canvas);
        this.fullScaleCanvas = new WorldNode(this, this.canvas);
        this.fullScaleCanvas.setScale(0.1);
        this.canvas.addWorldChild(this.fullScaleCanvas);
        this.solubleSaltsModel.addIonListener(new IonGraphicManager(this.fullScaleCanvas));
        Bond.addConstructionListener(new Bond.ConstructionListener(){
            HashMap bondToGraphic = new HashMap();

            public void instanceConstructed(Bond.ConstructionEvent constructionEvent) {
                if (SolubleSaltsConfig.SHOW_BONDS) {
                    BondGraphic bondGraphic = new BondGraphic(constructionEvent.getInstance());
                    SolubleSaltsModule.this.fullScaleCanvas.addChild(bondGraphic);
                    this.bondToGraphic.put(constructionEvent.getInstance(), bondGraphic);
                }
            }

            public void instanceRemoved(Bond.ConstructionEvent constructionEvent) {
                if (SolubleSaltsConfig.SHOW_BONDS) {
                    BondGraphic bondGraphic = (BondGraphic)this.bondToGraphic.get(constructionEvent.getInstance());
                    SolubleSaltsModule.this.fullScaleCanvas.removeChild(bondGraphic);
                }
            }
        });
        if (this.debug) {
            this.createTestIons(this.solubleSaltsModel);
        }
    }

    private void createTestIons(SolubleSaltsModel solubleSaltsModel) {
        Ion ion = new Chlorine();
        IonInitializer.initialize(ion, solubleSaltsModel);
        ion.setPosition(130.0, 200.0);
        ion.setVelocity(0.0, 5.0);
        ion = new Sodium();
        IonInitializer.initialize(ion, solubleSaltsModel);
        ion.setPosition(70.0, 230.0);
        ion.setVelocity(5.0, 0.0);
        ion = new Sodium();
        IonInitializer.initialize(ion, solubleSaltsModel);
        ion.setPosition(600.0, 435.0);
        ion.setVelocity(5.0, 0.0);
    }

    protected WorldNode getFullScaleCanvasNode() {
        return this.fullScaleCanvas;
    }

    public void setCalibration(SolubleSaltsConfig.Calibration calibration) {
        this.calibration = calibration;
    }

    public SolubleSaltsConfig.Calibration getCalibration() {
        return this.calibration;
    }

    public void reset() {
        this.resetListenerProxy.reset(this.calibration);
    }

    public void updateHTMLNode(HTMLNode hTMLNode) {
    }

    public double getMinimumFluidVolume() {
        return 0.0;
    }

    public void addResetListener(ResetListener resetListener) {
        this.resetEventChannel.addListener(resetListener);
    }

    public static interface ResetListener
    extends EventListener {
        public void reset(SolubleSaltsConfig.Calibration var1);
    }
}

