/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.solublesalts.model.salt;

import edu.colorado.phet.solublesalts.model.crystal.Lattice;
import java.security.InvalidParameterException;
import java.util.List;

public class Salt {
    private Lattice lattice;
    private Class anionClass;
    private Class cationClass;
    private Component[] components;
    private double ksp;

    protected Salt(List list, Lattice lattice, Class clazz, Class clazz2, double d) {
        int n;
        this.ksp = d;
        this.components = new Component[list.size()];
        for (n = 0; n < list.size(); ++n) {
            Component component;
            this.components[n] = component = (Component)list.get(n);
        }
        n = 0;
        while (n == 0) {
            n = 1;
            for (int i = 0; i < this.components.length - 1; ++i) {
                for (int j = i + 1; j < this.components.length; ++j) {
                    if (this.components[i].getLatticeUnitFraction() <= this.components[j].getLatticeUnitFraction()) continue;
                    Component component = this.components[i];
                    this.components[i] = this.components[j];
                    this.components[j] = component;
                    n = 0;
                }
            }
        }
        this.lattice = lattice;
        this.anionClass = clazz2;
        this.cationClass = clazz;
    }

    public Component[] getComponents() {
        return this.components;
    }

    public Lattice getLattice() {
        return this.lattice;
    }

    public Class getAnionClass() {
        return this.anionClass;
    }

    public Class getCationClass() {
        return this.cationClass;
    }

    public double getKsp() {
        return this.ksp;
    }

    public int getNumAnionsInUnit() {
        Integer n = this.getNumIonsInUnit(this.anionClass);
        if (n == null) {
            throw new InvalidParameterException();
        }
        return n;
    }

    public int getNumCationsInUnit() {
        Integer n = this.getNumIonsInUnit(this.cationClass);
        if (n == null) {
            throw new InvalidParameterException();
        }
        return n;
    }

    private Integer getNumIonsInUnit(Class clazz) {
        Integer n = null;
        for (int i = 0; i < this.components.length; ++i) {
            Component component = this.components[i];
            if (component.getIonClass() != clazz) continue;
            n = component.getLatticeUnitFraction();
        }
        return n;
    }

    public static class Component {
        Integer latticeUnitFraction;
        Class ionClass;

        public Component(Class clazz, Integer n) {
            this.latticeUnitFraction = n;
            this.ionClass = clazz;
        }

        public Integer getLatticeUnitFraction() {
            return this.latticeUnitFraction;
        }

        public Class getIonClass() {
            return this.ionClass;
        }
    }
}

