/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.solublesalts.model.ion;

import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.solublesalts.model.Atom;
import edu.colorado.phet.solublesalts.model.crystal.Crystal;
import edu.colorado.phet.solublesalts.model.ion.IonProperties;
import java.awt.geom.Point2D;
import java.util.EventListener;
import java.util.EventObject;

public class Ion
extends Atom {
    private IonProperties ionProperties;
    private Crystal bindingCrystal;
    private MutableVector2D vSaveUtil = new MutableVector2D();
    private EventChannel changeEventChannel = new EventChannel(ChangeListener.class);
    private ChangeListener changeListenerProxy = (ChangeListener)this.changeEventChannel.getListenerProxy();

    public Ion(IonProperties ionProperties) {
        this(new Point2D.Double(1.0, 1.0), new MutableVector2D(), new MutableVector2D(), ionProperties);
    }

    public Ion(Point2D point2D, MutableVector2D mutableVector2D, MutableVector2D mutableVector2D2, IonProperties ionProperties) {
        super(point2D, mutableVector2D, mutableVector2D2, ionProperties.getMass(), ionProperties.getRadius());
        this.ionProperties = ionProperties;
    }

    public void stepInTime(double d) {
        if (!this.isBound()) {
            super.stepInTime(d);
        } else {
            this.vSaveUtil.setComponents(this.getVelocity().getX(), this.getVelocity().getY());
            this.setVelocity(this.bindingCrystal.getVelocity());
            super.stepInTime(d);
            this.setVelocity(this.vSaveUtil);
        }
    }

    public void bindTo(Crystal crystal) {
        this.bindingCrystal = crystal;
        this.changeListenerProxy.stateChanged(new ChangeEvent(this));
    }

    public void unbindFrom(Crystal crystal) {
        this.bindingCrystal = null;
        this.changeListenerProxy.stateChanged(new ChangeEvent(this));
    }

    public boolean isBound() {
        return this.bindingCrystal != null;
    }

    public double getCharge() {
        return this.ionProperties.getCharge();
    }

    public Crystal getBindingCrystal() {
        return this.bindingCrystal;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeEventChannel.addListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeEventChannel.removeListener(changeListener);
    }

    public class ChangeEvent
    extends EventObject {
        public ChangeEvent(Ion ion2) {
            super(ion2);
        }
    }

    public static interface ChangeListener
    extends EventListener {
        public void stateChanged(ChangeEvent var1);
    }
}

