/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.solublesalts.model.crystal;

import edu.colorado.phet.solublesalts.model.crystal.Bond;
import edu.colorado.phet.solublesalts.model.ion.Ion;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class Node {
    private Ion ion;
    private List bonds = new ArrayList();

    public Node(Ion ion) {
        this.ion = ion;
    }

    public Ion getIon() {
        return this.ion;
    }

    public int getPolarity() {
        return (int)(this.ion.getCharge() / Math.abs(this.ion.getCharge()));
    }

    public List getBonds() {
        return this.bonds;
    }

    public void addBond(Bond bond) {
        this.bonds.add(bond);
    }

    public Point2D getPosition() {
        return this.ion.getPosition();
    }

    public void setBaseOrientation(double d) {
        double d2 = ((Bond)this.bonds.get(0)).getOrientation();
        for (int i = 0; i < this.bonds.size(); ++i) {
            Bond bond = (Bond)this.bonds.get(i);
            bond.setOrientation(bond.getOrientation() - d2 + d);
        }
    }

    public boolean hasNoChildren() {
        boolean bl = true;
        for (int i = 0; i < this.bonds.size() && bl; ++i) {
            Bond bond = (Bond)this.bonds.get(i);
            if (bond.getOrigin() != this || bond.getDestination() == null) continue;
            bl = false;
        }
        return bl;
    }

    public int getNumFilledBonds() {
        return this.bonds.size() - this.getNumOpenBonds();
    }

    public int getNumOpenBonds() {
        int n = 0;
        for (int i = 0; i < this.bonds.size(); ++i) {
            Bond bond = (Bond)this.bonds.get(i);
            n += bond.isOpen() ? 1 : 0;
        }
        return n;
    }
}

