/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.solublesalts.model.crystal;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.solublesalts.SolubleSaltsConfig;
import edu.colorado.phet.solublesalts.model.crystal.Bond;
import edu.colorado.phet.solublesalts.model.crystal.Node;
import edu.colorado.phet.solublesalts.model.ion.Ion;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public abstract class Lattice {
    private static Random random = new Random();
    private Ion seed;
    private Rectangle2D bounds;
    private List nodes = new ArrayList();
    protected double spacing;

    protected Lattice(double d) {
        this.spacing = d;
    }

    public boolean add(Ion ion) {
        boolean bl = false;
        if (this.nodes.size() == 0) {
            Node node = new Node(ion);
            int n = this.getNumNeighboringSites(ion);
            for (int i = 0; i < n; ++i) {
                double d = (double)i * Math.PI * 2.0 / (double)n;
                Bond bond = new Bond(node, d, this.spacing);
                bond.setOrigin(node);
                node.addBond(bond);
            }
            this.nodes.add(node);
            this.setSeed(ion);
            bl = true;
        } else if (this.nodes.size() == 1 && (double)((Node)this.nodes.get(0)).getPolarity() * ion.getCharge() < 0.0) {
            Node node = (Node)this.nodes.get(0);
            double d = MathUtil.getAngle(node.getPosition(), ion.getPosition());
            ion.setPosition(MathUtil.radialToCartesian(this.spacing, d, node.getPosition()));
            node.setBaseOrientation(d);
            Bond bond = (Bond)node.getBonds().get(random.nextInt(node.getBonds().size()));
            this.addNewNode(ion, bond);
            bl = true;
        } else {
            for (int i = 0; i < this.nodes.size() && !bl; ++i) {
                Node node = (Node)this.nodes.get(i);
                if (!((double)node.getPolarity() * ion.getCharge() < 0.0)) continue;
                List list = node.getBonds();
                for (int j = 0; j < list.size() && !bl; ++j) {
                    Bond bond = (Bond)list.get(j);
                    if (!bond.isOpen()) continue;
                    this.addNewNode(ion, bond);
                    bl = true;
                }
            }
        }
        return bl;
    }

    public boolean addAtIonNode(Ion ion, Ion ion2) {
        boolean bl = false;
        Node node = this.getNode(ion2);
        if (node == null) {
            throw new RuntimeException("originNode == null");
        }
        if (this.nodes.size() == 1) {
            double d = MathUtil.getAngle(node.getPosition(), ion.getPosition());
            node.setBaseOrientation(d);
        }
        List list = node.getBonds();
        ArrayList<Bond> arrayList = new ArrayList<Bond>();
        for (int i = 0; i < list.size() && !bl; ++i) {
            Bond bond = (Bond)list.get(i);
            if (!bond.isOpen() || !this.bounds.contains(bond.getOpenPosition())) continue;
            arrayList.add(bond);
        }
        Bond bond = null;
        if (arrayList.size() > 0) {
            double d = Double.MAX_VALUE;
            for (int i = 0; i < arrayList.size(); ++i) {
                Bond bond2 = (Bond)arrayList.get(i);
                double d2 = ion.getPosition().distanceSq(bond2.getOpenPosition());
                if (!(d2 < d)) continue;
                d = d2;
                bond = bond2;
            }
            if (bond == null) {
                throw new RuntimeException("bondToUse == null");
            }
            this.addNewNode(ion, bond);
            bl = true;
        }
        return bl;
    }

    private void addNewNode(Ion ion, Bond bond) {
        if (!bond.isOpen()) {
            bond.isOpen();
            throw new RuntimeException("Bond is not open");
        }
        ion.setPosition(bond.getOpenPosition());
        Node node = new Node(ion);
        node.addBond(bond);
        bond.setDestination(node);
        int n = this.getNumNeighboringSites(ion);
        for (int i = 1; i < n; ++i) {
            double d = ((double)i * Math.PI * 2.0 / (double)n + (bond.getOrientation() + Math.PI)) % (Math.PI * 2);
            boolean bl = true;
            Point2D point2D = MathUtil.radialToCartesian(this.spacing, d, node.getPosition());
            for (int j = 0; j < this.nodes.size() && bl; ++j) {
                Node node2 = (Node)this.nodes.get(j);
                List list = node2.getBonds();
                for (int k = 0; k < list.size(); ++k) {
                    Bond bond2 = (Bond)list.get(k);
                    if (!bond2.isOpen() || !MathUtil.isApproxEqual(bond2.getOrigin().getPosition(), point2D, 5.0) || !MathUtil.isApproxEqual(bond2.getOpenPosition(), ion.getPosition(), 5.0)) continue;
                    bond2.setDestination(node);
                    node.addBond(bond2);
                    bl = false;
                }
            }
            if (!bl) continue;
            Bond bond3 = new Bond(node, d, this.spacing);
            bond3.setOrigin(node);
            node.addBond(bond3);
        }
        this.nodes.add(node);
    }

    public Ion getBestIonToRelease(List list, Class clazz) {
        int n = 6;
        ArrayList[] arrayListArray = new ArrayList[n];
        for (int i = 0; i < arrayListArray.length; ++i) {
            arrayListArray[i] = new ArrayList();
        }
        ArrayList[] arrayListArray2 = new ArrayList[n];
        for (int i = 0; i < arrayListArray2.length; ++i) {
            arrayListArray2[i] = new ArrayList();
        }
        Ion ion = null;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        for (int i = 0; i < this.nodes.size(); ++i) {
            Node node = (Node)this.nodes.get(i);
            if (node.getIon() == this.seed && this.nodes.size() > 1 || !node.hasNoChildren()) continue;
            if (clazz.isAssignableFrom(node.getIon().getClass())) {
                arrayListArray[node.getNumFilledBonds()].add(node);
                continue;
            }
            arrayListArray2[node.getNumFilledBonds()].add(node);
        }
        List list2 = null;
        for (int i = 0; i < n && list2 == null; ++i) {
            if (arrayListArray[i].size() > 0) {
                list2 = arrayListArray[i];
                continue;
            }
            if (arrayListArray2[i].size() <= 0) continue;
            list2 = arrayListArray2[i];
        }
        if (list2.size() == 0) {
            throw new RuntimeException("candidates.size() == 0");
        }
        Node node = (Node)list2.get(random.nextInt(list2.size()));
        ion = node.getIon();
        return ion;
    }

    public List getOpenNeighboringSites(Ion ion) {
        List list = this.getNode(ion).getBonds();
        ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
        for (int i = 0; i < list.size(); ++i) {
            Point2D point2D;
            Bond bond = (Bond)list.get(i);
            if (!bond.isOpen() || !this.bounds.contains(point2D = MathUtil.radialToCartesian(this.spacing, bond.getOrientation(), ion.getPosition()))) continue;
            arrayList.add(point2D);
        }
        return arrayList;
    }

    public void removeIon(Ion ion) {
        Object object;
        int n;
        Node node = this.getNode(ion);
        if (node == null) {
            throw new RuntimeException();
        }
        List list = node.getBonds();
        for (n = 0; n < list.size(); ++n) {
            object = (Bond)list.get(n);
            ((Bond)object).removeNode(node);
        }
        this.nodes.remove(node);
        if (SolubleSaltsConfig.DEBUG) {
            for (n = 0; n < this.nodes.size(); ++n) {
                object = (Node)this.nodes.get(n);
                List list2 = ((Node)object).getBonds();
                for (int i = 0; i < list2.size(); ++i) {
                    Bond bond = (Bond)list2.get(i);
                    if (bond.getOrigin() != node && bond.getDestination() != node) continue;
                    throw new RuntimeException("existingBond.getOrigin() == node || existingBond.getDestination() == node");
                }
            }
        }
    }

    public Node getNode(Ion ion) {
        Node node = null;
        for (int i = 0; i < this.nodes.size() && node == null; ++i) {
            Node node2 = (Node)this.nodes.get(i);
            if (node2.getIon() != ion) continue;
            node = node2;
        }
        return node;
    }

    void setSeed(Ion ion) {
        Ion ion2 = null;
        if (this.seed != null && this.seed != ion) {
            ion2 = this.seed;
        }
        this.seed = ion;
        new SeedSetter().setSeed(this.seed);
        this.seed.notifyObservers();
        if (ion2 != null) {
            ion2.notifyObservers();
        }
    }

    protected Ion getSeed() {
        return this.seed;
    }

    void setBounds(Rectangle2D rectangle2D) {
        this.bounds = rectangle2D;
    }

    protected abstract int getNumNeighboringSites(Ion var1);

    public abstract Object clone();

    private class SeedSetter {
        private SeedSetter() {
        }

        void setSeed(Ion ion) {
            Node node = Lattice.this.getNode(ion);
            this.visitNode(node, new ArrayList(), null);
        }

        private void visitNode(Node node, List list, Bond bond) {
            List list2 = node.getBonds();
            list.add(node);
            for (int i = 0; i < list2.size(); ++i) {
                Node node2;
                Bond bond2 = (Bond)list2.get(i);
                if (bond2 != bond && bond2.getOrigin() != node) {
                    node2 = bond2.getOrigin();
                    bond2.removeNode(node2);
                    bond2.removeNode(node);
                    bond2.setOrigin(node);
                    bond2.setDestination(node2);
                    bond2.setOrientation(bond2.getOrientation() + Math.PI);
                }
                if ((node2 = bond2.getDestination()) == null || list.contains(node2)) continue;
                this.visitNode(node2, list, bond2);
            }
        }
    }
}

