/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.solublesalts.model.crystal;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.solublesalts.model.crystal.Node;
import java.awt.geom.Point2D;
import java.util.EventListener;
import java.util.EventObject;

public class Bond {
    static EventChannel constructionChannel = new EventChannel(ConstructionListener.class);
    static ConstructionListener constructionListenerProxy = (ConstructionListener)constructionChannel.getListenerProxy();
    private boolean debug;
    private Node[] nodes = new Node[2];
    private double orientation;
    private double length;
    private EventChannel changeEventChannel = new EventChannel(ChangeListener.class);
    private ChangeListener changeListenerProxy = (ChangeListener)this.changeEventChannel.getListenerProxy();

    public static void addConstructionListener(ConstructionListener constructionListener) {
        constructionChannel.addListener(constructionListener);
    }

    public Bond(Node node, double d, double d2) {
        this.setOrigin(node);
        this.orientation = d;
        this.length = d2;
        constructionListenerProxy.instanceConstructed(new ConstructionEvent(this));
    }

    protected void finalize() throws Throwable {
        super.finalize();
        constructionListenerProxy.instanceRemoved(new ConstructionEvent(this));
    }

    public void setOrigin(Node node) {
        this.nodes[0] = node;
        this.changeListenerProxy.stateChanged(new ChangeEvent(this));
    }

    public Node getOrigin() {
        return this.nodes[0];
    }

    public void setDestination(Node node) {
        if (this.nodes[1] != null) {
            throw new RuntimeException("destination already set");
        }
        this.nodes[1] = node;
        this.changeListenerProxy.stateChanged(new ChangeEvent(this));
    }

    public Node getDestination() {
        return this.nodes[1];
    }

    public void setOrientation(double d) {
        this.orientation = d;
        this.changeListenerProxy.stateChanged(new ChangeEvent(this));
    }

    public double getOrientation() {
        return this.orientation;
    }

    public boolean isOpen() {
        return this.nodes[1] == null;
    }

    public void removeNode(Node node) {
        if (this.nodes[0] == node) {
            this.nodes[0] = this.nodes[1];
            this.nodes[1] = null;
            this.setOrientation((this.getOrientation() + Math.PI) % (Math.PI * 2));
        } else if (this.nodes[1] == node) {
            this.nodes[1] = null;
        } else {
            throw new RuntimeException("node not associated with bond");
        }
        this.changeListenerProxy.stateChanged(new ChangeEvent(this));
    }

    public Point2D getOpenPosition() {
        if (!this.isOpen()) {
            throw new RuntimeException("bond not open");
        }
        return MathUtil.radialToCartesian(this.length, this.orientation, this.nodes[0].getPosition());
    }

    public boolean isDebugEnabled() {
        return this.debug;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeEventChannel.addListener(changeListener);
    }

    public class ChangeEvent
    extends EventObject {
        public ChangeEvent(Bond bond2) {
            super(bond2);
        }

        public Bond getBond() {
            return (Bond)this.getSource();
        }
    }

    public static interface ChangeListener
    extends EventListener {
        public void stateChanged(ChangeEvent var1);
    }

    public static class ConstructionEvent
    extends EventObject {
        private Bond bond;

        public ConstructionEvent(Bond bond) {
            super(Bond.class);
            this.bond = bond;
        }

        public Bond getInstance() {
            return this.bond;
        }
    }

    public static interface ConstructionListener
    extends EventListener {
        public void instanceConstructed(ConstructionEvent var1);

        public void instanceRemoved(ConstructionEvent var1);
    }
}

