/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.solublesalts.model;

import edu.colorado.phet.common.collision.Box2D;
import edu.colorado.phet.common.collision.Collidable;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.solublesalts.SolubleSaltsConfig;
import edu.colorado.phet.solublesalts.model.SolubleSaltsModel;
import edu.colorado.phet.solublesalts.model.affinity.Affinity;
import edu.colorado.phet.solublesalts.model.affinity.RandomAffinity;
import edu.colorado.phet.solublesalts.model.crystal.Crystal;
import edu.colorado.phet.solublesalts.model.ion.Ion;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;

public class Vessel
implements Collidable,
ModelElement {
    private Rectangle2D shape;
    private double wallThickness;
    private Point2D location = new Point2D.Double();
    private double waterLevel;
    private Box2D collisionBox;
    private ArrayList boundIons = new ArrayList();
    private Affinity ionReleaseAffinity = new RandomAffinity(0.001);
    private Affinity ionStickAffinity = new RandomAffinity(0.2);
    private SolubleSaltsModel model;
    private EventChannel changeEventChannel = new EventChannel(ChangeListener.class);
    private ChangeListener changeListenerProxy = (ChangeListener)this.changeEventChannel.getListenerProxy();

    public Vessel(double d, double d2, double d3, Point2D point2D, SolubleSaltsModel solubleSaltsModel) {
        this.wallThickness = d3;
        this.model = solubleSaltsModel;
        this.shape = new Rectangle2D.Double(point2D.getX(), point2D.getY(), d, d2);
        this.location = point2D;
        this.waterLevel = d2;
        this.collisionBox = new Box2D();
        this.updateCollisionBox();
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Vessel.this.updateCollisionBox();
            }
        });
        solubleSaltsModel.addChangeListener(new SolubleSaltsModel.ChangeAdapter(){});
    }

    private void updateCollisionBox() {
        this.collisionBox.setBounds(this.getShape().getMinX(), this.getShape().getMaxY() - this.waterLevel, this.getShape().getMaxX(), this.getShape().getMaxY());
    }

    public void bind(Ion ion) {
        if (!SolubleSaltsConfig.ONE_CRYSTAL_ONLY || this.model.crystalTracker.getCrystals().size() == 0) {
            Crystal crystal = new Crystal(this.model, this.model.getCurrentSalt().getLattice(), ion);
            crystal.addIon(ion);
            crystal.setBound(true);
        }
    }

    public Box2D getWater() {
        return this.collisionBox;
    }

    public double getWaterLevel() {
        return this.waterLevel;
    }

    public void setWaterLevel(double d) {
        this.setWaterLevel(d, true);
    }

    public void setWaterLevel(double d, boolean bl) {
        this.waterLevel = Math.max(0.0, Math.min(d, this.getDepth()));
        this.changeListenerProxy.stateChanged(new ChangeEvent(this, bl));
    }

    public Rectangle2D getShape() {
        return this.shape;
    }

    public boolean isOutside(Point2D point2D) {
        return !(this.getShape().getMinX() - this.wallThickness < point2D.getX() && this.getShape().getMinY() < point2D.getY() && this.getShape().getMaxX() + this.wallThickness > point2D.getX() && this.getShape().getMaxY() + this.wallThickness > point2D.getY());
    }

    public Point2D getLocation() {
        return this.location;
    }

    public double getWidth() {
        return this.shape.getWidth();
    }

    public double getDepth() {
        return this.shape.getHeight();
    }

    public double getWallThickness() {
        return this.wallThickness;
    }

    public void setIonStickAffinity(Affinity affinity) {
        this.ionStickAffinity = affinity;
    }

    public Affinity getIonStickAffinity() {
        return this.ionStickAffinity;
    }

    public void stepInTime(double d) {
        for (int i = 0; i < this.boundIons.size(); ++i) {
            Ion ion = (Ion)this.boundIons.get(i);
            if (!this.ionReleaseAffinity.stick(ion, this)) continue;
            this.boundIons.remove(ion);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeEventChannel.addListener(changeListener);
    }

    public class ChangeEvent
    extends EventObject {
        private final boolean fromFaucet;

        public ChangeEvent(Vessel vessel2, boolean bl) {
            super(vessel2);
            this.fromFaucet = bl;
        }

        public Vessel getVessel() {
            return (Vessel)this.getSource();
        }

        public boolean isFromFaucet() {
            return this.fromFaucet;
        }
    }

    public static interface ChangeListener
    extends EventListener {
        public void stateChanged(ChangeEvent var1);
    }
}

