/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.solublesalts.model;

import edu.colorado.phet.common.collision.Collidable;
import edu.colorado.phet.common.mechanics.Body;
import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.model.BaseModel;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.solublesalts.SolubleSaltsConfig;
import edu.colorado.phet.solublesalts.model.CrystalTracker;
import edu.colorado.phet.solublesalts.model.CrystalVesselCollisionExpert;
import edu.colorado.phet.solublesalts.model.Drain;
import edu.colorado.phet.solublesalts.model.HeatSource;
import edu.colorado.phet.solublesalts.model.IonFlowManager;
import edu.colorado.phet.solublesalts.model.IonIonCollisionExpert;
import edu.colorado.phet.solublesalts.model.IonTracker;
import edu.colorado.phet.solublesalts.model.IonVesselCollisionExpert;
import edu.colorado.phet.solublesalts.model.RandomWalk;
import edu.colorado.phet.solublesalts.model.Shaker;
import edu.colorado.phet.solublesalts.model.Vessel;
import edu.colorado.phet.solublesalts.model.WaterSource;
import edu.colorado.phet.solublesalts.model.crystal.Crystal;
import edu.colorado.phet.solublesalts.model.ion.Ion;
import edu.colorado.phet.solublesalts.model.ion.IonListener;
import edu.colorado.phet.solublesalts.model.salt.Salt;
import edu.colorado.phet.solublesalts.module.ISolubleSaltsModelContainer;
import edu.colorado.phet.solublesalts.module.SolubleSaltsModule;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolubleSaltsModel
extends BaseModel
implements SolubleSaltsModule.ResetListener {
    private double scale = 1.0;
    Rectangle2D bounds = new Rectangle2D.Double(0.0, 0.0, 1024.0, 850.0);
    double ksp;
    private Vessel vessel;
    protected Point2D vesselLoc = new Point2D.Double(SolubleSaltsConfig.VESSEL_ULC.getX() * this.scale, SolubleSaltsConfig.VESSEL_ULC.getY() * this.scale);
    protected double vesselWidth = SolubleSaltsConfig.VESSEL_SIZE.getWidth() * this.scale;
    protected double vesselDepth = SolubleSaltsConfig.VESSEL_SIZE.getHeight() * this.scale;
    protected double vesselWallThickness = 20.0 * this.scale;
    private WaterSource waterSource;
    private Drain drain;
    private IonTracker ionTracker;
    private HeatSource heatSource;
    private boolean nucleationEnabled;
    private Shaker shaker;
    public CrystalTracker crystalTracker;
    private MutableVector2D accelerationOutOfWater = new MutableVector2D(0.0, 0.2);
    private MutableVector2D accelerationInWater = new MutableVector2D();
    private RandomWalk randomWalkAgent;
    private SolubleSaltsConfig.Calibration calibration;
    private final IClock clock;
    private EventChannel changeEventChannel = new EventChannel(ChangeListener.class);
    private ChangeListener changeListenerProxy = (ChangeListener)this.changeEventChannel.getListenerProxy();

    public SolubleSaltsModel(IClock iClock, ISolubleSaltsModelContainer iSolubleSaltsModelContainer) {
        this.clock = iClock;
        this.calibration = iSolubleSaltsModelContainer.getCalibration();
        iSolubleSaltsModelContainer.addResetListener(this);
        iClock.addClockListener(new ModelStepper());
        this.ionTracker = new IonTracker();
        this.crystalTracker = new CrystalTracker(this);
        Crystal.addInstanceLifetimeListener(this.crystalTracker);
        this.vessel = this.newVessel();
        this.vessel.setWaterLevel(this.calibration.defaultWaterLevel / this.calibration.volumeCalibrationFactor);
        this.addModelElement(this.vessel);
        this.randomWalkAgent = new RandomWalk(this.vessel);
        this.waterSource = new WaterSource(this);
        this.waterSource.setPosition(this.vessel.getLocation().getX() + 35.0, this.vessel.getLocation().getY() - 10.0);
        this.addModelElement(this.waterSource);
        this.drain = new Drain(this, new Point2D.Double(this.vessel.getLocation().getX() - this.vessel.getWallThickness(), this.vessel.getLocation().getY() + this.vessel.getDepth() - 30.0), 60.0, Drain.HORIZONTAL, this.vesselWallThickness, iSolubleSaltsModelContainer.getMinimumFluidVolume());
        this.addModelElement(this.drain);
        new IonFlowManager(this);
        this.addModelElement(new CollisionAgent());
        this.heatSource = new HeatSource(this);
        this.addModelElement(this.heatSource);
        this.addModelElement(new NucleationMonitorAgent());
        this.shaker = new Shaker(this);
        this.shaker.setPosition(this.vessel.getLocation().getX() + this.vessel.getWidth() / 2.0, this.vessel.getLocation().getY() - 10.0);
        iSolubleSaltsModelContainer.addResetListener(new SolubleSaltsModule.ResetListener(){

            public void reset(SolubleSaltsConfig.Calibration calibration) {
                SolubleSaltsModel.this.vessel.setWaterLevel(((SolubleSaltsModel)SolubleSaltsModel.this).calibration.defaultWaterLevel / ((SolubleSaltsModel)SolubleSaltsModel.this).calibration.volumeCalibrationFactor);
            }
        });
    }

    protected Vessel newVessel() {
        return new Vessel(this.vesselWidth, this.vesselDepth, this.vesselWallThickness, this.vesselLoc, this);
    }

    @Override
    public void update(ClockEvent clockEvent) {
        super.update(clockEvent);
        List list = this.crystalTracker.getCrystals();
        for (int i = 0; i < list.size(); ++i) {
            Crystal crystal = (Crystal)list.get(i);
            if (!crystal.isBound() && !crystal.getAcceleration().equals(this.accelerationOutOfWater)) {
                crystal.setAcceleration(this.accelerationOutOfWater);
                continue;
            }
            if (!this.vessel.getWater().getBounds().contains(crystal.getPosition()) || crystal.getAcceleration().equals(this.accelerationInWater)) continue;
            crystal.setAcceleration(this.accelerationInWater);
            crystal.setVelocity(0.0, 3.0);
        }
    }

    @Override
    public void addModelElement(ModelElement modelElement) {
        super.addModelElement(modelElement);
        if (modelElement instanceof Ion) {
            Ion ion = (Ion)modelElement;
            this.ionTracker.ionAdded(ion);
        }
    }

    @Override
    public void removeModelElement(ModelElement modelElement) {
        super.removeModelElement(modelElement);
        if (modelElement instanceof Ion) {
            Ion ion = (Ion)modelElement;
            this.ionTracker.ionRemoved(ion);
            if (ion.isBound()) {
                ion.getBindingCrystal().removeIon(ion);
            }
        }
    }

    @Override
    public void reset(SolubleSaltsConfig.Calibration calibration) {
        this.calibration = calibration;
        List<Ion> list = this.ionTracker.getIons();
        for (int i = 0; i < list.size(); ++i) {
            Ion ion = list.get(i);
            this.removeModelElement(ion);
        }
        this.vessel.setWaterLevel(this.calibration.defaultWaterLevel / this.calibration.volumeCalibrationFactor);
        this.waterSource.setFlow(0.0);
        this.drain.setFlow(0.0);
        this.heatSource.setHeatChangePerClockTick(0.0);
        ChangeEvent changeEvent = new ChangeEvent(this);
        changeEvent.setModelReset(true);
        this.changeListenerProxy.stateChanged(changeEvent);
    }

    public Class getPreferredTypeOfIonToRelease() {
        int n = this.getNumFreeIonsOfType(this.getCurrentSalt().getAnionClass());
        int n2 = this.getNumFreeIonsOfType(this.getCurrentSalt().getCationClass());
        Class clazz = null;
        clazz = (double)n / (double)n2 < (double)this.getCurrentSalt().getNumAnionsInUnit() / (double)this.getCurrentSalt().getNumCationsInUnit() ? this.getCurrentSalt().getAnionClass() : this.getCurrentSalt().getCationClass();
        return clazz;
    }

    public boolean isNucleationEnabled() {
        return this.nucleationEnabled;
    }

    public Rectangle2D getBounds() {
        return this.bounds;
    }

    public void setKsp(double d) {
        this.ksp = d;
    }

    public Vessel getVessel() {
        return this.vessel;
    }

    public WaterSource getFaucet() {
        return this.waterSource;
    }

    public Drain getDrain() {
        return this.drain;
    }

    public int getNumIonsOfType(Class clazz) {
        return this.ionTracker.getNumIonsOfType(clazz);
    }

    public List<Ion> getIonsOfType(Class clazz) {
        return this.ionTracker.getIonsOfType(clazz);
    }

    public int getNumFreeIonsOfType(Class clazz) {
        return this.ionTracker.getNumFreeIonsOfType(clazz);
    }

    public int getNumBoundIonsOfType(Class clazz) {
        return this.getNumIonsOfType(clazz) - this.getNumFreeIonsOfType(clazz);
    }

    public List<Ion> getIons() {
        return this.ionTracker.getIons();
    }

    public List getCrystals() {
        return this.crystalTracker.getCrystals();
    }

    public double getConcentrationFactor() {
        Salt salt = this.getCurrentSalt();
        int n = this.ionTracker.getNumFreeIonsOfType(salt.getAnionClass());
        int n2 = salt.getNumAnionsInUnit();
        int n3 = this.ionTracker.getNumFreeIonsOfType(salt.getCationClass());
        int n4 = salt.getNumCationsInUnit();
        double d = this.vessel.getWaterLevel() * this.calibration.volumeCalibrationFactor;
        double d2 = d * 6.022E23;
        double d3 = Math.pow((double)n / d2, n2) * Math.pow((double)n3 / d2, n4);
        return d3;
    }

    public Shaker getShaker() {
        return this.shaker;
    }

    public void addHeat(double d) {
        List<Ion> list = this.getIons();
        for (int i = 0; i < list.size(); ++i) {
            Ion ion = list.get(i);
            double d2 = ion.getVelocity().magnitude();
            double d3 = Math.sqrt(Math.max(0.001, d2 * d2 + 2.0 * d / ion.getMass()));
            if (!(ion.getVelocity().magnitude() > 0.0)) continue;
            ion.setVelocity(ion.getVelocity().normalize().scale(d3));
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeEventChannel.addListener(changeListener);
    }

    public void addIonListener(IonListener ionListener) {
        this.ionTracker.addIonListener(ionListener);
    }

    public void setCurrentSalt(Salt salt) {
        this.shaker.setCurrentSalt(salt);
        this.ksp = salt.getKsp();
        ChangeEvent changeEvent = new ChangeEvent(this);
        changeEvent.setSaltChanged(true);
        this.changeListenerProxy.stateChanged(changeEvent);
    }

    public Salt getCurrentSalt() {
        return this.shaker.getCurrentSalt();
    }

    public RandomWalk getRandomWalkAgent() {
        return this.randomWalkAgent;
    }

    public static class ChangeAdapter
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
        }
    }

    public class ChangeEvent
    extends EventObject {
        private boolean saltChanged;
        private boolean modelReset;

        public ChangeEvent(SolubleSaltsModel solubleSaltsModel2) {
            super(solubleSaltsModel2);
        }

        public SolubleSaltsModel getModel() {
            return (SolubleSaltsModel)this.getSource();
        }

        public boolean isSaltChanged() {
            return this.saltChanged;
        }

        public void setSaltChanged(boolean bl) {
            this.saltChanged = bl;
        }

        public boolean isModelReset() {
            return this.modelReset;
        }

        public void setModelReset(boolean bl) {
            this.modelReset = bl;
        }
    }

    public static interface ChangeListener
    extends EventListener {
        public void stateChanged(ChangeEvent var1);
    }

    private class CollisionAgent
    implements ModelElement {
        CrystalVesselCollisionExpert crystalVesselCollisionExpert = new CrystalVesselCollisionExpert();
        IonVesselCollisionExpert ionVesselCollisionExpert = new IonVesselCollisionExpert(SolubleSaltsModel.this);
        IonIonCollisionExpert ionIonCollisionExpert = new IonIonCollisionExpert(SolubleSaltsModel.this);

        private CollisionAgent() {
        }

        public void stepInTime(double d) {
            Body body;
            int n;
            List list = SolubleSaltsModel.this.crystalTracker.getCrystals();
            for (n = 0; n < list.size(); ++n) {
                body = (Crystal)list.get(n);
                this.crystalVesselCollisionExpert.detectAndDoCollision((Collidable)((Object)body), SolubleSaltsModel.this.getVessel());
            }
            for (n = 0; n < SolubleSaltsModel.this.numModelElements(); ++n) {
                if (!(SolubleSaltsModel.this.modelElementAt(n) instanceof Ion)) continue;
                body = (Ion)SolubleSaltsModel.this.modelElementAt(n);
                this.ionVesselCollisionExpert.detectAndDoCollision((Collidable)((Object)body), SolubleSaltsModel.this.vessel);
                for (int i = 0; i < SolubleSaltsModel.this.numModelElements(); ++i) {
                    if (SolubleSaltsModel.this.modelElementAt(n) == SolubleSaltsModel.this.modelElementAt(i) || !(SolubleSaltsModel.this.modelElementAt(i) instanceof Ion)) continue;
                    this.ionIonCollisionExpert.detectAndDoCollision((Ion)SolubleSaltsModel.this.modelElementAt(n), (Ion)SolubleSaltsModel.this.modelElementAt(i));
                }
            }
        }
    }

    private class ModelStepper
    extends ClockAdapter {
        private ModelStepper() {
        }

        public void clockTicked(ClockEvent clockEvent) {
            List<Ion> list = SolubleSaltsModel.this.ionTracker.getIons();
            for (int i = 0; i < list.size(); ++i) {
                Ion ion = list.get(i);
                if (SolubleSaltsConfig.RANDOM_WALK && SolubleSaltsModel.this.drain.getFlow() == 0.0) {
                    SolubleSaltsModel.this.randomWalkAgent.apply(ion);
                }
                if (SolubleSaltsModel.this.getBounds().contains(ion.getPosition())) continue;
                SolubleSaltsModel.this.removeModelElement(ion);
            }
        }
    }

    private class NucleationMonitorAgent
    implements ModelElement,
    Crystal.InstanceLifetimeListener {
        private List crystals = new ArrayList();
        private Random random = new Random();

        public NucleationMonitorAgent() {
            Crystal.addInstanceLifetimeListener(this);
        }

        public void stepInTime(double d) {
            SolubleSaltsModel.this.nucleationEnabled = this.isNucleationAllowed();
            boolean bl = true;
            while (this.crystals.size() > 0 && !SolubleSaltsModel.this.nucleationEnabled && bl && SolubleSaltsModel.this.drain.getFlow() == 0.0) {
                bl = false;
                int n = this.random.nextInt(this.crystals.size());
                Crystal crystal = (Crystal)this.crystals.get(n);
                if (crystal.isInWater(SolubleSaltsModel.this.vessel.getWater().getBounds())) {
                    crystal.releaseIon(d);
                    bl = true;
                }
                SolubleSaltsModel.this.nucleationEnabled = this.isNucleationAllowed();
            }
        }

        private boolean isNucleationAllowed() {
            return SolubleSaltsModel.this.getConcentrationFactor() > SolubleSaltsModel.this.ksp && SolubleSaltsModel.this.drain.getFlow() == 0.0;
        }

        public void instanceCreated(Crystal.InstanceLifetimeEvent instanceLifetimeEvent) {
            this.crystals.add(instanceLifetimeEvent.getInstance());
        }

        public void instanceDestroyed(Crystal.InstanceLifetimeEvent instanceLifetimeEvent) {
            this.crystals.remove(instanceLifetimeEvent.getInstance());
        }
    }
}

