/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.solublesalts.model;

import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.solublesalts.model.ion.Ion;
import edu.colorado.phet.solublesalts.model.ion.IonEvent;
import edu.colorado.phet.solublesalts.model.ion.IonListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IonTracker {
    private HashMap<Class, List<Ion>> ionMap = new HashMap();
    private EventChannel ionEventChannel = new EventChannel(IonListener.class);
    private IonListener ionListenerProxy = (IonListener)this.ionEventChannel.getListenerProxy();

    public void ionAdded(Ion ion) {
        List<Ion> list = this.ionMap.get(ion.getClass());
        if (list == null) {
            list = new ArrayList<Ion>();
            this.ionMap.put(ion.getClass(), list);
        }
        list.add(ion);
        this.ionListenerProxy.ionAdded(new IonEvent(ion));
    }

    public void ionRemoved(Ion ion) {
        this.ionMap.get(ion.getClass()).remove(ion);
        this.ionListenerProxy.ionRemoved(new IonEvent(ion));
    }

    public int getNumIonsOfType(Class clazz) {
        int n = 0;
        List<Ion> list = this.ionMap.get(clazz);
        if (list != null) {
            n = list.size();
        }
        return n;
    }

    public int getNumFreeIonsOfType(Class clazz) {
        Collection collection = this.ionMap.get(clazz);
        int n = 0;
        if (collection != null) {
            for (Ion ion : collection) {
                n += ion.isBound() ? 0 : 1;
            }
        }
        return n;
    }

    public List<Ion> getIonsOfType(Class clazz) {
        if (this.ionMap.containsKey(clazz)) {
            return this.ionMap.get(clazz);
        }
        return new ArrayList<Ion>();
    }

    public List<Ion> getIons() {
        ArrayList<Ion> arrayList = new ArrayList<Ion>();
        Collection<List<Ion>> collection = this.ionMap.values();
        for (List<Ion> list : collection) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public void addIonListener(IonListener ionListener) {
        this.ionEventChannel.addListener(ionListener);
    }
}

