/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.solublesalts.model;

import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.solublesalts.model.SolubleSaltsModel;
import edu.colorado.phet.solublesalts.model.Vessel;
import edu.colorado.phet.solublesalts.model.ion.Ion;
import java.awt.geom.Point2D;
import java.util.Random;

public class IonInitializer {
    private static Random random = new Random(System.currentTimeMillis());
    private static double vMax = 3.0;
    private static double vMin = 1.0;

    public static void initialize(Ion ion, SolubleSaltsModel solubleSaltsModel) {
        ion.setPosition(IonInitializer.genIonPosition(ion, solubleSaltsModel));
        ion.setVelocity(IonInitializer.genIonVelocity());
    }

    private static Point2D genIonPosition(Ion ion, SolubleSaltsModel solubleSaltsModel) {
        Vessel vessel = solubleSaltsModel.getVessel();
        double d = vessel.getWater().getMinX() + ion.getRadius() * 2.0 + random.nextDouble() * (vessel.getWater().getWidth() - ion.getRadius() * 2.0);
        double d2 = vessel.getWater().getMinY() + ion.getRadius() * 2.0 + random.nextDouble() * (vessel.getWater().getHeight() - ion.getRadius() * 2.0);
        return new Point2D.Double(d, d2);
    }

    private static MutableVector2D genIonVelocity() {
        return new MutableVector2D((random.nextDouble() * (vMax - vMin) + vMin) * (double)(random.nextBoolean() ? 1 : -1), (random.nextDouble() * (vMax - vMin) + vMin) * (double)(random.nextBoolean() ? 1 : -1));
    }
}

