/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.solublesalts.model;

import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.solublesalts.model.SolubleSaltsModel;
import edu.colorado.phet.solublesalts.model.Spigot;
import edu.colorado.phet.solublesalts.model.Vessel;
import edu.colorado.phet.solublesalts.model.ion.Ion;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class Drain
extends Spigot
implements Vessel.ChangeListener {
    private Vessel vessel;
    private final double minWaterLevel;
    public static Orientation HORIZONTAL = new Orientation();
    public static Orientation VERTICAL = new Orientation();
    private Line2D opening;
    private int ionCaptureDistance = 2;
    private MutableVector2D inputToOutputOffset = new MutableVector2D(-95.0, 50.0);

    public Drain(SolubleSaltsModel solubleSaltsModel, Point2D point2D, double d, Orientation orientation, double d2, double d3) {
        super(solubleSaltsModel);
        this.minWaterLevel = d3;
        this.setPosition(point2D);
        this.vessel = solubleSaltsModel.getVessel();
        this.vessel.addChangeListener(this);
        if (orientation == HORIZONTAL) {
            this.opening = new Line2D.Double(point2D.getX() + d2, point2D.getY() - d / 2.0, point2D.getX() + d2, point2D.getY() + d / 2.0);
        } else if (orientation == VERTICAL) {
            this.opening = new Line2D.Double(point2D.getX() - d / 2.0, point2D.getY(), point2D.getX() + d / 2.0, point2D.getY());
        } else {
            throw new RuntimeException("Invalid orientation");
        }
    }

    public void stepInTime(double d) {
        if (this.getFlow() != 0.0) {
            Ion ion;
            int n;
            Vessel vessel = this.getModel().getVessel();
            double d2 = vessel.getWidth();
            double d3 = vessel.getWaterLevel() - this.getFlow() / d2;
            vessel.setWaterLevel(d3);
            ArrayList<Ion> arrayList = new ArrayList<Ion>();
            List<Ion> list = this.getModel().getIons();
            for (n = 0; n < list.size(); ++n) {
                ion = list.get(n);
                if (ion.isBound() || !(this.opening.ptSegDist(ion.getPosition()) < ion.getRadius() * (double)this.ionCaptureDistance)) continue;
                arrayList.add(ion);
            }
            for (n = 0; n < arrayList.size(); ++n) {
                ion = (Ion)arrayList.get(n);
                ion.setPosition(new Point2D.Double(this.getPosition().getX() + this.inputToOutputOffset.getX(), this.getPosition().getY() + this.inputToOutputOffset.getY()));
                ion.setVelocity(new MutableVector2D(ion.getVelocity().magnitude(), 0.0).rotate(1.5707963267948966));
            }
        }
    }

    public void setFlow(double d) {
        if (this.vessel.getWaterLevel() > this.minWaterLevel) {
            super.setFlow(d);
        } else {
            super.setFlow(0.0);
        }
    }

    public void stateChanged(Vessel.ChangeEvent changeEvent) {
        Vessel vessel = changeEvent.getVessel();
        if (vessel.getWaterLevel() <= this.minWaterLevel) {
            this.setFlow(0.0);
        }
    }

    public static class Orientation {
    }
}

