/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.solublesalts.control;

import edu.colorado.phet.common.mechanics.Body;
import edu.colorado.phet.solublesalts.SolubleSaltResources;
import edu.colorado.phet.solublesalts.model.IonInitializer;
import edu.colorado.phet.solublesalts.model.SolubleSaltsModel;
import edu.colorado.phet.solublesalts.model.Vessel;
import edu.colorado.phet.solublesalts.model.crystal.Crystal;
import edu.colorado.phet.solublesalts.model.ion.Arsenate;
import edu.colorado.phet.solublesalts.model.ion.Bromine;
import edu.colorado.phet.solublesalts.model.ion.Chlorine;
import edu.colorado.phet.solublesalts.model.ion.Chromium;
import edu.colorado.phet.solublesalts.model.ion.ConfigurableAnion;
import edu.colorado.phet.solublesalts.model.ion.ConfigurableCation;
import edu.colorado.phet.solublesalts.model.ion.Copper;
import edu.colorado.phet.solublesalts.model.ion.Hydroxide;
import edu.colorado.phet.solublesalts.model.ion.Iodide;
import edu.colorado.phet.solublesalts.model.ion.Ion;
import edu.colorado.phet.solublesalts.model.ion.IonEvent;
import edu.colorado.phet.solublesalts.model.ion.IonFactory;
import edu.colorado.phet.solublesalts.model.ion.IonListener;
import edu.colorado.phet.solublesalts.model.ion.Lead;
import edu.colorado.phet.solublesalts.model.ion.Mercury;
import edu.colorado.phet.solublesalts.model.ion.Phosphate;
import edu.colorado.phet.solublesalts.model.ion.Silver;
import edu.colorado.phet.solublesalts.model.ion.Sodium;
import edu.colorado.phet.solublesalts.model.ion.Strontium;
import edu.colorado.phet.solublesalts.model.ion.Sulfur;
import edu.colorado.phet.solublesalts.model.ion.Thallium;
import edu.colorado.phet.solublesalts.model.salt.Salt;
import edu.colorado.phet.solublesalts.util.DefaultGridBagConstraints;
import edu.colorado.phet.solublesalts.view.IonGraphicManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SaltSpinnerPanel
extends JPanel
implements SolubleSaltsModel.ChangeListener,
Ion.ChangeListener {
    private static HashMap ionClassToName = new HashMap();
    Salt salt;
    IonSpinner anionSpinner;
    IonSpinner cationSpinner;
    public int anionRatio;
    public int cationRatio;
    public Class anionClass;
    public Class cationClass;
    private SolubleSaltsModel model;
    public JLabel anionLabel;
    public JLabel cationLabel;
    public IonSpinnerChangeListener anionSpinnerListener;
    public IonSpinnerChangeListener cationSpinnerListener;
    private JTextField numFreeAnionTF;
    private JTextField numFreeCationTF;
    private final int maxIons = 400;
    private JTextField numBoundAnionTF;
    private JTextField numBoundCationTF;
    private JLabel ionsLabel;
    private JLabel totalNumLabel;
    private JLabel freeNumLabel;
    private JLabel boundNumLabel;
    private Random random = new Random();

    public SaltSpinnerPanel(final SolubleSaltsModel solubleSaltsModel) {
        super(new GridBagLayout());
        this.model = solubleSaltsModel;
        solubleSaltsModel.addChangeListener(this);
        this.cationClass = solubleSaltsModel.getCurrentSalt().getCationClass();
        String string = this.getIonName(this.cationClass);
        this.cationLabel = new JLabel(string, new ImageIcon(IonGraphicManager.getIonImage(this.cationClass)), 4);
        this.cationLabel.setPreferredSize(new Dimension(85, 20));
        this.cationLabel.setHorizontalAlignment(0);
        this.anionClass = solubleSaltsModel.getCurrentSalt().getAnionClass();
        String string2 = this.getIonName(this.anionClass);
        this.anionLabel = new JLabel(string2, new ImageIcon(IonGraphicManager.getIonImage(this.anionClass)), 4);
        this.anionLabel.setPreferredSize(new Dimension(85, 20));
        this.anionLabel.setHorizontalAlignment(0);
        this.cationSpinner = new IonSpinner();
        this.anionSpinner = new IonSpinner();
        int n = 4;
        this.numFreeAnionTF = new JTextField("", n);
        this.numFreeAnionTF.setEditable(false);
        this.numFreeAnionTF.setHorizontalAlignment(4);
        this.numFreeCationTF = new JTextField("", n);
        this.numFreeCationTF.setEditable(false);
        this.numFreeCationTF.setHorizontalAlignment(4);
        this.numBoundAnionTF = new JTextField("", n);
        this.numBoundAnionTF.setEditable(false);
        this.numBoundAnionTF.setHorizontalAlignment(4);
        this.numBoundCationTF = new JTextField("", n);
        this.numBoundCationTF.setEditable(false);
        this.numBoundCationTF.setHorizontalAlignment(4);
        solubleSaltsModel.addIonListener(new IonListener(){

            public void ionAdded(IonEvent ionEvent) {
                SaltSpinnerPanel.this.syncSpinnersWithModel();
                ionEvent.getIon().addChangeListener(SaltSpinnerPanel.this);
            }

            public void ionRemoved(IonEvent ionEvent) {
                SaltSpinnerPanel.this.syncSpinnersWithModel();
                ionEvent.getIon().removeChangeListener(SaltSpinnerPanel.this);
            }
        });
        solubleSaltsModel.getVessel().addChangeListener(new Vessel.ChangeListener(){

            public void stateChanged(Vessel.ChangeEvent changeEvent) {
                Vessel vessel = changeEvent.getVessel();
                double d = vessel.getLocation().getY() + vessel.getDepth() - solubleSaltsModel.getDrain().getPosition().getY();
                boolean bl = vessel.getWaterLevel() > d;
                SaltSpinnerPanel.this.anionSpinner.setEnabled(bl);
                SaltSpinnerPanel.this.cationSpinner.setEnabled(bl);
            }
        });
        this.ionsLabel = new JLabel(SolubleSaltResources.getString("ControlLabels.Ions"));
        this.totalNumLabel = new JLabel(SolubleSaltResources.getString("ControlLabels.Total"));
        this.freeNumLabel = new JLabel(SolubleSaltResources.getString("ControlLabels.Free"));
        this.boundNumLabel = new JLabel(SolubleSaltResources.getString("ControlLabels.Bound"));
        this.layoutPanel();
    }

    private void layoutPanel() {
        DefaultGridBagConstraints defaultGridBagConstraints = new DefaultGridBagConstraints();
        defaultGridBagConstraints.insets = new Insets(5, 0, 0, 5);
        defaultGridBagConstraints.weightx = 0.5;
        defaultGridBagConstraints.gridx = -1;
        defaultGridBagConstraints.gridy = 0;
        defaultGridBagConstraints.anchor = 13;
        this.add((Component)this.ionsLabel, defaultGridBagConstraints);
        defaultGridBagConstraints.anchor = 10;
        this.add((Component)this.cationLabel, defaultGridBagConstraints);
        this.add((Component)this.anionLabel, defaultGridBagConstraints);
        ++defaultGridBagConstraints.gridy;
        defaultGridBagConstraints.gridx = -1;
        defaultGridBagConstraints.anchor = 13;
        this.add((Component)this.freeNumLabel, defaultGridBagConstraints);
        defaultGridBagConstraints.anchor = 10;
        this.add((Component)this.numFreeCationTF, defaultGridBagConstraints);
        this.add((Component)this.numFreeAnionTF, defaultGridBagConstraints);
        ++defaultGridBagConstraints.gridy;
        defaultGridBagConstraints.gridx = -1;
        defaultGridBagConstraints.anchor = 13;
        this.add((Component)this.boundNumLabel, defaultGridBagConstraints);
        defaultGridBagConstraints.anchor = 10;
        this.add((Component)this.numBoundCationTF, defaultGridBagConstraints);
        this.add((Component)this.numBoundAnionTF, defaultGridBagConstraints);
        ++defaultGridBagConstraints.gridy;
        defaultGridBagConstraints.gridx = -1;
        defaultGridBagConstraints.anchor = 13;
        this.add((Component)this.totalNumLabel, defaultGridBagConstraints);
        defaultGridBagConstraints.anchor = 10;
        this.add((Component)this.cationSpinner, defaultGridBagConstraints);
        this.add((Component)this.anionSpinner, defaultGridBagConstraints);
    }

    private void syncSpinnersWithModel() {
        this.anionSpinner.setSyncWithDependentIonspinner(false);
        this.anionSpinner.setValue(new Integer(this.model.getNumIonsOfType(this.anionClass)));
        this.anionSpinner.setSyncWithDependentIonspinner(true);
        this.cationSpinner.setSyncWithDependentIonspinner(false);
        this.cationSpinner.setValue(new Integer(this.model.getNumIonsOfType(this.cationClass)));
        this.cationSpinner.setSyncWithDependentIonspinner(true);
        this.numFreeAnionTF.setText(new Integer(this.model.getNumFreeIonsOfType(this.anionClass)).toString());
        this.numFreeCationTF.setText(new Integer(this.model.getNumFreeIonsOfType(this.cationClass)).toString());
        this.numBoundAnionTF.setText(new Integer(this.model.getNumBoundIonsOfType(this.anionClass)).toString());
        this.numBoundCationTF.setText(new Integer(this.model.getNumBoundIonsOfType(this.cationClass)).toString());
    }

    public void setSalt(Salt salt) {
        Salt.Component[] componentArray;
        if (salt.getAnionClass() != this.anionClass) {
            this.anionClass = salt.getAnionClass();
            componentArray = this.getIonName(this.anionClass);
            this.anionLabel.setText((String)componentArray);
            this.anionLabel.setIcon(new ImageIcon(IonGraphicManager.getIonImage(this.anionClass)));
        }
        if (salt.getCationClass() != this.cationClass) {
            this.cationClass = salt.getCationClass();
            componentArray = this.getIonName(this.cationClass);
            this.cationLabel.setText((String)componentArray);
            this.cationLabel.setIcon(new ImageIcon(IonGraphicManager.getIonImage(this.cationClass)));
        }
        this.salt = salt;
        this.anionRatio = 0;
        this.cationRatio = 0;
        this.anionClass = salt.getAnionClass();
        this.cationClass = salt.getCationClass();
        componentArray = salt.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Salt.Component component = componentArray[i];
            if (component.getIonClass() == this.anionClass) {
                this.anionRatio = component.getLatticeUnitFraction();
            }
            if (component.getIonClass() != this.cationClass) continue;
            this.cationRatio = component.getLatticeUnitFraction();
        }
        this.anionSpinner.setModel(new SpinnerNumberModel(0, 0, 400, this.anionRatio));
        this.anionSpinner.removeChangeListener(this.anionSpinnerListener);
        this.anionSpinnerListener = new IonSpinnerChangeListener(this.anionSpinner, this.cationSpinner, this.anionClass, this.anionRatio, this.cationRatio);
        this.anionSpinner.addChangeListener(this.anionSpinnerListener);
        this.cationSpinner.setModel(new SpinnerNumberModel(0, 0, 400, this.cationRatio));
        this.cationSpinner.removeChangeListener(this.cationSpinnerListener);
        this.cationSpinnerListener = new IonSpinnerChangeListener(this.cationSpinner, this.anionSpinner, this.cationClass, this.cationRatio, this.anionRatio);
        this.cationSpinner.addChangeListener(this.cationSpinnerListener);
    }

    public void stateChanged(Ion.ChangeEvent changeEvent) {
        this.syncSpinnersWithModel();
    }

    public void stateChanged(SolubleSaltsModel.ChangeEvent changeEvent) {
        if (changeEvent.isSaltChanged()) {
            this.setSalt(changeEvent.getModel().getCurrentSalt());
        }
        if (changeEvent.isModelReset()) {
            this.syncSpinnersWithModel();
        }
    }

    private String getIonName(Class clazz) {
        String string = (String)ionClassToName.get(clazz);
        return string;
    }

    static {
        ionClassToName.put(ConfigurableCation.class, SolubleSaltResources.getString("Ion.cation"));
        ionClassToName.put(Sodium.class, SolubleSaltResources.getString("Ion.sodium"));
        ionClassToName.put(Lead.class, SolubleSaltResources.getString("Ion.lead"));
        ionClassToName.put(Chromium.class, SolubleSaltResources.getString("Ion.chromium"));
        ionClassToName.put(Copper.class, SolubleSaltResources.getString("Ion.copper"));
        ionClassToName.put(Silver.class, SolubleSaltResources.getString("Ion.silver"));
        ionClassToName.put(Thallium.class, SolubleSaltResources.getString("Ion.thallium"));
        ionClassToName.put(Strontium.class, SolubleSaltResources.getString("Ion.strontium"));
        ionClassToName.put(Mercury.class, SolubleSaltResources.getString("Ion.mercury"));
        ionClassToName.put(ConfigurableAnion.class, SolubleSaltResources.getString("Ion.anion"));
        ionClassToName.put(Phosphate.class, SolubleSaltResources.getString("Ion.phosphate"));
        ionClassToName.put(Bromine.class, SolubleSaltResources.getString("Ion.bromide"));
        ionClassToName.put(Arsenate.class, SolubleSaltResources.getString("Ion.aresenate"));
        ionClassToName.put(Sulfur.class, SolubleSaltResources.getString("Ion.sulfide"));
        ionClassToName.put(Chlorine.class, SolubleSaltResources.getString("Ion.chloride"));
        ionClassToName.put(Iodide.class, SolubleSaltResources.getString("Ion.iodide"));
        ionClassToName.put(Hydroxide.class, SolubleSaltResources.getString("Ion.hydroxide"));
    }

    private class IonSpinner
    extends JSpinner {
        private boolean syncWithDependentIonspinner = true;

        private IonSpinner() {
        }

        public boolean isSyncWithDependentIonspinner() {
            return this.syncWithDependentIonspinner;
        }

        public void setSyncWithDependentIonspinner(boolean bl) {
            this.syncWithDependentIonspinner = bl;
        }
    }

    private class IonSpinnerChangeListener
    implements ChangeListener {
        private IonSpinner spinner;
        private IonSpinner dependentSpinner;
        private Class ionClass;
        private int ionRatio;
        private int dependentIonRatio;

        IonSpinnerChangeListener(IonSpinner ionSpinner, IonSpinner ionSpinner2, Class clazz, int n, int n2) {
            this.spinner = ionSpinner;
            this.dependentSpinner = ionSpinner2;
            this.ionClass = clazz;
            this.ionRatio = n;
            this.dependentIonRatio = n2;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (this.spinner.isSyncWithDependentIonspinner()) {
                int n = (Integer)this.spinner.getValue() - SaltSpinnerPanel.this.model.getNumIonsOfType(this.ionClass);
                if (n > 0) {
                    IonFactory ionFactory = new IonFactory();
                    for (int i = 0; i < n; ++i) {
                        Ion ion = ionFactory.create(this.ionClass);
                        IonInitializer.initialize(ion, SaltSpinnerPanel.this.model);
                        SaltSpinnerPanel.this.model.addModelElement(ion);
                    }
                }
                if (n < 0) {
                    for (int i = n; i < 0; ++i) {
                        Body body;
                        List<Ion> list = SaltSpinnerPanel.this.model.getIonsOfType(this.ionClass);
                        boolean bl = false;
                        for (int j = 0; j < list.size() && !bl; ++j) {
                            body = list.get(j);
                            if (((Ion)body).isBound()) continue;
                            SaltSpinnerPanel.this.model.removeModelElement(body);
                            bl = true;
                        }
                        if (bl) continue;
                        List list2 = SaltSpinnerPanel.this.model.getCrystals();
                        body = (Crystal)list2.get(SaltSpinnerPanel.this.random.nextInt(list2.size()));
                        ((Crystal)body).releaseIon(1.0);
                    }
                }
                this.dependentSpinner.setValue(new Integer(SaltSpinnerPanel.this.model.getNumIonsOfType(this.ionClass) * this.dependentIonRatio / this.ionRatio));
            }
        }
    }
}

