/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.solublesalts.control;

import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.util.PhetUtilities;
import edu.colorado.phet.common.phetcommon.view.ModelSlider;
import edu.colorado.phet.solublesalts.SolubleSaltResources;
import edu.colorado.phet.solublesalts.SolubleSaltsConfig;
import edu.colorado.phet.solublesalts.control.SolubleSaltsControlPanel;
import edu.colorado.phet.solublesalts.model.IonFlowManager;
import edu.colorado.phet.solublesalts.model.SolubleSaltsModel;
import edu.colorado.phet.solublesalts.view.IonGraphic;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DeveloperMenuSetup
extends JMenu {
    public static void setup(JMenu jMenu, final JFrame jFrame) {
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Show bond indicators");
        jMenu.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IonGraphic.showBondIndicators(jCheckBoxMenuItem.isSelected());
            }
        });
        final JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem("Random walk", SolubleSaltsConfig.RANDOM_WALK);
        jMenu.add(jCheckBoxMenuItem2);
        jCheckBoxMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SolubleSaltsConfig.RANDOM_WALK = jCheckBoxMenuItem2.isSelected();
            }
        });
        final JCheckBoxMenuItem jCheckBoxMenuItem3 = new JCheckBoxMenuItem("One crystal only");
        jMenu.add(jCheckBoxMenuItem3);
        jCheckBoxMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SolubleSaltsConfig.ONE_CRYSTAL_ONLY = jCheckBoxMenuItem3.isSelected();
            }
        });
        JMenuItem jMenuItem = new JMenuItem("Adjust random walk...");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                final JDialog jDialog = new JDialog(jFrame, "Adjust Random Walk", false);
                jDialog.getContentPane().setLayout(new BorderLayout());
                final SolubleSaltsModel solubleSaltsModel = (SolubleSaltsModel)PhetApplication.getInstance().getActiveModule().getModel();
                final JSlider jSlider = new JSlider(0, 360, (int)solubleSaltsModel.getRandomWalkAgent().getTheta());
                jSlider.setMajorTickSpacing(45);
                jSlider.setMinorTickSpacing(15);
                jSlider.setPaintTicks(true);
                jSlider.setPaintLabels(true);
                jSlider.addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent changeEvent) {
                        solubleSaltsModel.getRandomWalkAgent().setTheta(jSlider.getValue());
                    }
                });
                jDialog.getContentPane().add(jSlider);
                JButton jButton = new JButton("Close");
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        jDialog.setVisible(false);
                    }
                });
                JPanel jPanel = new JPanel();
                jPanel.add(jButton);
                jDialog.getContentPane().add((Component)jPanel, "South");
                jDialog.pack();
                jDialog.setVisible(true);
            }
        });
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Adjust binding distance...");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                final JDialog jDialog = new JDialog(jFrame, "Binding Distance", false);
                jDialog.getContentPane().setLayout(new BorderLayout());
                final ModelSlider modelSlider = new ModelSlider("Binding Distance", "", 0.0, 4.0, SolubleSaltsConfig.BINDING_DISTANCE_FACTOR, new DecimalFormat("0.0"));
                modelSlider.setMajorTickSpacing(0.5);
                modelSlider.setPaintTicks(true);
                modelSlider.setPaintLabels(true);
                modelSlider.addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent changeEvent) {
                        SolubleSaltsConfig.BINDING_DISTANCE_FACTOR = modelSlider.getValue();
                    }
                });
                jDialog.getContentPane().add(modelSlider);
                JButton jButton = new JButton("Close");
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        jDialog.setVisible(false);
                    }
                });
                JPanel jPanel = new JPanel();
                jPanel.add(jButton);
                jDialog.getContentPane().add((Component)jPanel, "South");
                jDialog.pack();
                jDialog.setVisible(true);
            }
        });
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Set drain flow effect on ions...");
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                final JDialog jDialog = new JDialog(jFrame, SolubleSaltResources.getString("Drain Flow Effect"), false);
                jDialog.getContentPane().setLayout(new BorderLayout());
                final ModelSlider modelSlider = new ModelSlider("Drain Flow Effect", "", 0.0, 100.0, IonFlowManager.SPEED_FACTOR, new DecimalFormat("0.0E0"));
                modelSlider.addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent changeEvent) {
                        IonFlowManager.SPEED_FACTOR = modelSlider.getValue();
                    }
                });
                jDialog.getContentPane().add(modelSlider);
                JButton jButton = new JButton("Close");
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        jDialog.setVisible(false);
                    }
                });
                JPanel jPanel = new JPanel();
                jPanel.add(jButton);
                jDialog.getContentPane().add((Component)jPanel, "South");
                jDialog.pack();
                jDialog.setVisible(true);
            }
        });
        jMenu.add(jMenuItem3);
        final JCheckBoxMenuItem jCheckBoxMenuItem4 = new JCheckBoxMenuItem("Show debug controls...");
        jCheckBoxMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SolubleSaltsControlPanel solubleSaltsControlPanel = (SolubleSaltsControlPanel)PhetUtilities.getActiveModule().getControlPanel();
                solubleSaltsControlPanel.setDebugControlsVisible(jCheckBoxMenuItem4.isSelected());
            }
        });
        jMenu.add(jCheckBoxMenuItem4);
    }
}

