/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.model;

import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.util.SimpleObservable;
import java.awt.geom.Point2D;

public class Particle
extends SimpleObservable
implements ModelElement {
    private Point2D position = new Point2D.Double();
    private MutableVector2D velocity = new MutableVector2D();
    private MutableVector2D acceleration = new MutableVector2D();
    private MutableVector2D prevAcceleration = new MutableVector2D();

    public Particle() {
    }

    public Object clone() {
        Particle particle = (Particle)super.clone();
        particle.position = new Point2D.Double(this.position.getX(), this.position.getY());
        particle.velocity = new MutableVector2D(this.velocity);
        particle.acceleration = new MutableVector2D(this.acceleration);
        particle.prevAcceleration = new MutableVector2D(this.prevAcceleration);
        return particle;
    }

    protected Particle(Point2D point2D, MutableVector2D mutableVector2D, MutableVector2D mutableVector2D2) {
        this.setPosition(point2D);
        this.setVelocity(mutableVector2D);
        this.setAcceleration(mutableVector2D2);
    }

    public Point2D getPosition() {
        return this.position;
    }

    public void setPosition(double d, double d2) {
        this.position.setLocation(d, d2);
        this.notifyObservers();
    }

    public void setPosition(Point2D point2D) {
        this.setPosition(point2D.getX(), point2D.getY());
    }

    public MutableVector2D getVelocity() {
        return this.velocity;
    }

    public void setVelocity(MutableVector2D mutableVector2D) {
        this.setVelocity(mutableVector2D.getX(), mutableVector2D.getY());
    }

    public void setVelocity(double d, double d2) {
        this.velocity.setComponents(d, d2);
        this.notifyObservers();
    }

    public MutableVector2D getAcceleration() {
        return this.acceleration;
    }

    public void setAcceleration(MutableVector2D mutableVector2D) {
        this.setAcceleration(mutableVector2D.getX(), mutableVector2D.getY());
    }

    public void setAcceleration(double d, double d2) {
        this.setAccelerationNoUpdate(d, d2);
        this.notifyObservers();
    }

    public void setAccelerationNoUpdate(double d, double d2) {
        this.prevAcceleration.setComponents(this.acceleration.getX(), this.acceleration.getY());
        this.acceleration.setComponents(d, d2);
    }

    public void stepInTime(double d) {
        double d2 = this.position.getX() + d * this.velocity.getX() + d * d * this.acceleration.getX() / 2.0;
        double d3 = this.position.getY() + d * this.velocity.getY() + d * d * this.acceleration.getY() / 2.0;
        this.setPosition(d2, d3);
        if (this.prevAcceleration == null) {
            this.prevAcceleration = this.acceleration;
        }
        double d4 = this.velocity.getX() + d * (this.acceleration.getX() + this.prevAcceleration.getX()) / 2.0;
        double d5 = this.velocity.getY() + d * (this.acceleration.getY() + this.prevAcceleration.getY()) / 2.0;
        this.setVelocity(d4, d5);
        this.prevAcceleration.setComponents(this.acceleration.getX(), this.acceleration.getY());
        this.notifyObservers();
    }

    public void translate(double d, double d2) {
        this.setPosition(this.position.getX() + d, this.position.getY() + d2);
        this.notifyObservers();
    }
}

