/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.math;

import java.awt.geom.Point2D;
import java.util.Random;

public class MathUtil {
    private static final Random random = new Random(System.currentTimeMillis());
    public static final double SQRT_2 = Math.sqrt(2.0);

    public static int nextRandomSign() {
        return random.nextBoolean() ? 1 : -1;
    }

    public static boolean isApproxEqual(Point2D point2D, Point2D point2D2, double d) {
        return MathUtil.isApproxEqual(point2D.getX(), point2D2.getX(), d) && MathUtil.isApproxEqual(point2D.getY(), point2D2.getY(), d);
    }

    public static boolean isApproxEqual(double d, double d2, double d3) {
        return Math.abs(d - d2) < d3;
    }

    public static double clamp(double d, double d2, double d3) {
        if (Double.isNaN(d) || Double.isNaN(d2) || Double.isNaN(d3)) {
            return Double.NaN;
        }
        if (d2 < d) {
            return d;
        }
        if (d2 > d3) {
            return d3;
        }
        return d2;
    }

    public static double getAngle(Point2D point2D, Point2D point2D2) {
        double d = Math.atan2(point2D2.getY() - point2D.getY(), point2D2.getX() - point2D.getX());
        return d;
    }

    public static Point2D radialToCartesian(double d, double d2, Point2D point2D) {
        double d3 = d * Math.cos(d2);
        double d4 = d * Math.sin(d2);
        return new Point2D.Double(point2D.getX() + d3, point2D.getY() + d4);
    }

    public static int getLeastCommonMultiple(int n, int n2) {
        boolean bl = false;
        int n3 = 0;
        n = n < 0 ? -n : n;
        int n4 = n2 = n2 < 0 ? -n2 : n2;
        while (!bl) {
            ++n3;
            int n5 = n / n2;
            while (n5 * n2 <= n3 * n) {
                if (n5 * n2 == n3 * n) {
                    bl = true;
                }
                ++n5;
            }
        }
        return n * n3;
    }

    public static long daysToMilliseconds(long l) {
        return l * 24L * 60L * 60L * 1000L;
    }
}

