/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.mechanics;

import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.model.Particle;
import java.awt.geom.Point2D;

public abstract class Body
extends Particle {
    private Particle lastColidedBody = null;
    private double theta;
    private double omega;
    private double alpha;
    private double prevAlpha;
    private double mass;
    private MutableVector2D momentum = new MutableVector2D();

    public Object clone() {
        Body body = (Body)super.clone();
        body.lastColidedBody = this.lastColidedBody == null ? null : (Particle)this.lastColidedBody.clone();
        body.momentum = new MutableVector2D(this.momentum);
        return body;
    }

    protected Body() {
    }

    protected Body(Point2D point2D, MutableVector2D mutableVector2D, MutableVector2D mutableVector2D2, double d, double d2) {
        super(point2D, mutableVector2D, mutableVector2D2);
        this.setMass(d);
    }

    public void stepInTime(double d) {
        this.theta = this.theta + d * this.omega + d * d * this.alpha / 2.0;
        this.omega += d * (this.alpha + this.prevAlpha) / 2.0;
        this.prevAlpha = this.alpha;
        super.stepInTime(d);
        this.momentum.setComponents(this.getVelocity().getX() * this.getMass(), this.getVelocity().getY() * this.getMass());
    }

    public double getMass() {
        return this.mass;
    }

    public void setMass(double d) {
        this.mass = d;
    }
}

