/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.event;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.event.PDragSequenceEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventFilter;
import java.awt.geom.Point2D;

public class PZoomEventHandler
extends PDragSequenceEventHandler {
    private double minScale = 0.0;
    private double maxScale = Double.MAX_VALUE;
    private Point2D viewZoomPoint;

    public PZoomEventHandler() {
        this.setEventFilter(new PInputEventFilter(4));
    }

    protected void dragActivityFirstStep(PInputEvent pInputEvent) {
        this.viewZoomPoint = pInputEvent.getPosition();
        super.dragActivityFirstStep(pInputEvent);
    }

    protected void dragActivityStep(PInputEvent pInputEvent) {
        PCamera pCamera = pInputEvent.getCamera();
        double d = pInputEvent.getCanvasPosition().getX() - this.getMousePressedCanvasPoint().getX();
        double d2 = 1.0 + 0.001 * d;
        double d3 = pCamera.getViewScale();
        double d4 = d3 * d2;
        if (d4 < this.minScale) {
            d2 = this.minScale / d3;
        }
        if (this.maxScale > 0.0 && d4 > this.maxScale) {
            d2 = this.maxScale / d3;
        }
        pCamera.scaleViewAboutPoint(d2, this.viewZoomPoint.getX(), this.viewZoomPoint.getY());
    }

    protected String paramString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("minScale=" + this.minScale);
        stringBuffer.append(",maxScale=" + this.maxScale);
        stringBuffer.append(",viewZoomPoint=" + (this.viewZoomPoint == null ? "null" : this.viewZoomPoint.toString()));
        stringBuffer.append(',');
        stringBuffer.append(super.paramString());
        return stringBuffer.toString();
    }
}

