/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.util.persistence;

import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import java.awt.Frame;

public class XMLPersistenceManager {
    private static final String SAVE_TITLE = PhetCommonResources.getInstance().getLocalizedString("XMLPersistenceManager.save.title");
    private static final String SAVE_CONFIRM_MESSAGE = PhetCommonResources.getInstance().getLocalizedString("XMLPersistenceManager.save.confirm.message");
    private static final String SAVE_ERROR_MESSAGE = PhetCommonResources.getInstance().getLocalizedString("XMLPersistenceManager.save.error.message");
    private static final String SAVE_ERROR_ENCODE = PhetCommonResources.getInstance().getLocalizedString("XMLPersistenceManager.save.error.encode");
    private static final String LOAD_TITLE = PhetCommonResources.getInstance().getLocalizedString("XMLPersistenceManager.load.title");
    private static final String LOAD_ERROR_MESSAGE = PhetCommonResources.getInstance().getLocalizedString("XMLPersistenceManager.load.error.message");
    private static final String LOAD_ERROR_DECODE = PhetCommonResources.getInstance().getLocalizedString("XMLPersistenceManager.load.error.decode");
    private static final String LOAD_ERROR_CONTENTS = PhetCommonResources.getInstance().getLocalizedString("XMLPersistenceManager.load.error.contents");
    private static final String ERROR_TITLE = PhetCommonResources.getInstance().getLocalizedString("XMLPersistenceManager.title.error");
    private ISaveLoadStrategy _saveLoadStrategy;

    public XMLPersistenceManager(Frame frame) {
        this._saveLoadStrategy = XMLPersistenceManager.wasWebStarted() ? new WebStartSaveLoadStrategy(frame) : new LocalSaveLoadStrategy(frame);
    }

    private static boolean wasWebStarted() {
        return System.getProperty("javawebstart.version") != null;
    }

    private static abstract class AbstractObjectSaveLoadStrategy
    implements ISaveLoadStrategy {
        private Frame _parentFrame;
        private String _mostRecentDirectoryName;

        public AbstractObjectSaveLoadStrategy(Frame frame) {
            this._parentFrame = frame;
            this._mostRecentDirectoryName = null;
        }
    }

    private static interface ISaveLoadStrategy {
    }

    private static class LocalSaveLoadStrategy
    extends AbstractObjectSaveLoadStrategy {
        public LocalSaveLoadStrategy(Frame frame) {
            super(frame);
        }
    }

    private static class WebStartSaveLoadStrategy
    extends AbstractObjectSaveLoadStrategy {
        public WebStartSaveLoadStrategy(Frame frame) {
            super(frame);
        }
    }
}

