/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.updates;

import edu.colorado.phet.common.phetcommon.application.ISimInfo;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.dialogs.DownloadProgressDialog;
import edu.colorado.phet.common.phetcommon.dialogs.ErrorDialog;
import edu.colorado.phet.common.phetcommon.files.PhetInstallation;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.resources.PhetVersion;
import edu.colorado.phet.common.phetcommon.updates.dialogs.UpdateErrorDialog;
import edu.colorado.phet.common.phetcommon.util.DeploymentScenario;
import edu.colorado.phet.common.phetcommon.util.DownloadThread;
import edu.colorado.phet.common.phetcommon.util.FileUtils;
import edu.colorado.phet.common.phetcommon.util.PhetUtilities;
import edu.colorado.phet.common.phetcommon.util.logging.USLogger;
import edu.colorado.phet.common.phetcommon.view.util.HTMLUtils;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.jar.JarFile;

public class SimUpdater {
    private static final String ERROR_WRITE_PERMISSIONS = PhetCommonResources.getString("Common.updates.errorWritePermissions");
    private static final String ERROR_MISSING_JAR = PhetCommonResources.getString("Common.updates.errorMissingJar");
    private static final String ERROR_NOT_A_JAR = PhetCommonResources.getString("Common.updates.errorNotAJar");
    private final File tmpDir = new File(System.getProperty("java.io.tmpdir"));

    public void updateSim(ISimInfo iSimInfo, PhetVersion phetVersion) {
        if (!this.tmpDir.canWrite()) {
            SimUpdater.handleErrorWritePermissions(this.tmpDir);
        } else {
            try {
                File file = this.getSimJAR(iSimInfo.getFlavor());
                if (file == null) {
                    SimUpdater.handleErrorMissingJar(file);
                } else if (!file.canWrite()) {
                    SimUpdater.handleErrorWritePermissions(file);
                } else {
                    String string = this.getJarURL(iSimInfo);
                    this.log("requesting update via URL=" + string);
                    File file2 = this.getTempSimJAR(file);
                    File file3 = this.getTempUpdaterJAR();
                    boolean bl = this.downloadFiles("http://phet.colorado.edu/phet-dist/phet-updater/phet-updater.jar", file3, string, file2, iSimInfo.getName(), phetVersion);
                    if (bl) {
                        boolean bl2 = this.validateUpdateJar(file3);
                        boolean bl3 = this.validateSimJar(file2);
                        if (bl2 && bl3) {
                            this.startUpdaterBootstrap(file3, file2, file);
                            System.exit(0);
                        }
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.showException(iOException);
            }
        }
    }

    private String getJarURL(ISimInfo iSimInfo) {
        if (DeploymentScenario.getInstance() == DeploymentScenario.PHET_INSTALLATION) {
            return HTMLUtils.getProjectJarURL(iSimInfo.getProjectName(), "&");
        }
        return HTMLUtils.getSimJarURL(iSimInfo.getProjectName(), iSimInfo.getFlavor(), iSimInfo.getLocale());
    }

    private void showException(Exception exception) {
        UpdateErrorDialog updateErrorDialog = new UpdateErrorDialog((Frame)PhetApplication.getInstance().getPhetFrame(), exception);
        ((Dialog)updateErrorDialog).setVisible(true);
    }

    private boolean downloadFiles(String string, File file, String string2, File file2, String string3, PhetVersion phetVersion) throws IOException {
        DownloadThread downloadThread = new DownloadThread();
        downloadThread.addRequest(PhetCommonResources.getString("Common.updates.downloadingBootstrap"), string, file);
        downloadThread.addRequest(PhetCommonResources.getString("Common.updates.downloadingSimJar"), string2, file2);
        String string4 = PhetCommonResources.getString("Common.updates.progressDialogTitle");
        Object[] objectArray = new Object[]{string3, phetVersion.formatMajorMinor()};
        String string5 = MessageFormat.format(PhetCommonResources.getString("Common.updates.progressDialogMessage"), objectArray);
        DownloadProgressDialog downloadProgressDialog = new DownloadProgressDialog(null, string4, string5, downloadThread);
        downloadThread.start();
        downloadProgressDialog.setVisible(true);
        return downloadThread.getSucceeded();
    }

    private void startUpdaterBootstrap(File file, File file2, File file3) throws IOException {
        String[] stringArray = new String[]{PhetUtilities.getJavaPath(), "-jar", file.getAbsolutePath(), file2.getAbsolutePath(), file3.getAbsolutePath()};
        this.log("Starting updater bootstrap with cmdArray=" + Arrays.asList(stringArray).toString());
        Runtime.getRuntime().exec(stringArray);
    }

    private File getSimJAR(String string) throws IOException {
        File file = null;
        if (DeploymentScenario.getInstance() == DeploymentScenario.PHET_INSTALLATION) {
            file = PhetInstallation.getInstance().getInstalledJarFile();
        } else {
            file = FileUtils.getCodeSource();
            if (!FileUtils.hasSuffix(file, "jar")) {
                file = File.createTempFile(string, ".jar");
                this.log("Not running from a JAR, you are likely running from an IDE, update will be installed at " + file);
            }
            this.log("running sim JAR is " + file.getAbsolutePath());
        }
        return file;
    }

    private File getTempSimJAR(File file) throws IOException {
        String string = FileUtils.getBasename(file);
        File file2 = File.createTempFile(string, ".jar");
        this.log("temporary JAR is " + file2.getAbsolutePath());
        return file2;
    }

    private File getTempUpdaterJAR() throws IOException {
        File file = new File(this.tmpDir.getAbsolutePath() + System.getProperty("file.separator") + "phet-updater.jar");
        if (file.exists() && !file.canWrite()) {
            file = File.createTempFile("phet-updater", ".jar");
        }
        this.log("Downloading updater to " + file.getAbsolutePath());
        return file;
    }

    private boolean validateSimJar(File file) {
        boolean bl = true;
        try {
            new JarFile(file);
        }
        catch (IOException iOException) {
            bl = false;
            SimUpdater.handleErrorSimJar(file);
        }
        return bl;
    }

    private boolean validateUpdateJar(File file) {
        boolean bl = true;
        try {
            new JarFile(file);
        }
        catch (IOException iOException) {
            bl = false;
            SimUpdater.handleErrorNotAJar(file);
        }
        return bl;
    }

    private void log(String string) {
        USLogger.log(this.getClass().getName() + ": " + string);
    }

    private static void handleErrorSimJar(File file) {
        try {
            String string;
            String string2 = "";
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                string2 = string2 + string;
            }
            bufferedReader.close();
            SimUpdater.displayError(string2);
        }
        catch (IOException iOException) {
            SimUpdater.handleErrorNotAJar(file);
        }
    }

    private static void handleErrorWritePermissions(File file) {
        Object[] objectArray = new Object[]{file.getAbsolutePath()};
        String string = MessageFormat.format(ERROR_WRITE_PERMISSIONS, objectArray);
        SimUpdater.displayError(string);
    }

    private static void handleErrorMissingJar(File file) {
        Object[] objectArray = new Object[]{file.getAbsolutePath()};
        String string = MessageFormat.format(ERROR_MISSING_JAR, objectArray);
        SimUpdater.displayError(string);
    }

    private static void handleErrorNotAJar(File file) {
        Object[] objectArray = new Object[]{file.getAbsolutePath()};
        String string = MessageFormat.format(ERROR_NOT_A_JAR, objectArray);
        SimUpdater.displayError(string);
    }

    private static void displayError(String string) {
        ErrorDialog errorDialog = new ErrorDialog((Frame)null, string);
        SwingUtils.centerWindowOnScreen(errorDialog);
        ((Dialog)errorDialog).setVisible(true);
    }
}

