/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.simexample.module.example;

import edu.colorado.phet.common.piccolophet.PiccoloModule;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.PiccoloClockControlPanel;
import edu.colorado.phet.simexample.SimExampleApplication;
import edu.colorado.phet.simexample.SimExampleStrings;
import edu.colorado.phet.simexample.defaults.ExampleDefaults;
import edu.colorado.phet.simexample.model.ExampleModelElement;
import edu.colorado.phet.simexample.model.SimExampleClock;
import edu.colorado.phet.simexample.module.example.ExampleCanvas;
import edu.colorado.phet.simexample.module.example.ExampleControlPanel;
import edu.colorado.phet.simexample.module.example.ExampleModel;
import edu.colorado.phet.simexample.persistence.ExampleConfig;
import java.awt.Frame;

public class ExampleModule
extends PiccoloModule {
    private ExampleModel model;
    private ExampleCanvas canvas;
    private ExampleControlPanel controlPanel;
    private PiccoloClockControlPanel clockControlPanel;

    public ExampleModule(Frame frame) {
        super(SimExampleStrings.TITLE_EXAMPLE_MODULE, new SimExampleClock(25, 1.0));
        SimExampleClock simExampleClock = (SimExampleClock)this.getClock();
        this.model = new ExampleModel(simExampleClock);
        this.canvas = new ExampleCanvas(this.model);
        this.setSimulationPanel(this.canvas);
        this.controlPanel = new ExampleControlPanel(this, frame, this.model);
        this.setControlPanel(this.controlPanel);
        this.clockControlPanel = new PiccoloClockControlPanel(this.getClock());
        this.clockControlPanel.setRewindButtonVisible(true);
        this.clockControlPanel.setTimeDisplayVisible(true);
        this.clockControlPanel.setUnits(SimExampleStrings.UNITS_TIME);
        this.clockControlPanel.setTimeColumns(10);
        this.setClockControlPanel(this.clockControlPanel);
        if (this.hasHelp()) {
            // empty if block
        }
        this.reset();
    }

    public void reset() {
        SimExampleClock simExampleClock = this.model.getClock();
        simExampleClock.resetSimulationTime();
        this.load(ExampleDefaults.getInstance().getConfig());
    }

    public ExampleConfig save() {
        ExampleConfig exampleConfig = new ExampleConfig();
        exampleConfig.setActive(this.isActive());
        SimExampleClock simExampleClock = this.model.getClock();
        exampleConfig.setClockDt(simExampleClock.getDt());
        exampleConfig.setClockRunning(this.getClockRunningWhenActive());
        ExampleModelElement exampleModelElement = this.model.getExampleModelElement();
        exampleConfig.setExampleModelElementPosition(exampleModelElement.getPositionReference());
        exampleConfig.setExampleModelElementOrientation(exampleModelElement.getOrientation());
        return exampleConfig;
    }

    public void load(ExampleConfig exampleConfig) {
        if (exampleConfig.isActive()) {
            SimExampleApplication.getInstance().setActiveModule(this);
        }
        SimExampleClock simExampleClock = this.model.getClock();
        simExampleClock.setDt(exampleConfig.getClockDt());
        this.setClockRunningWhenActive(exampleConfig.isClockRunning());
        ExampleModelElement exampleModelElement = this.model.getExampleModelElement();
        exampleModelElement.setPosition(exampleConfig.getExampleModelElementPosition());
        exampleModelElement.setOrientation(exampleConfig.getExampleModelElementOrientation());
    }
}

