/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.simexample.model;

import edu.colorado.phet.common.phetcommon.math.PolarCartesianConverter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;

public class ExampleModelElement
extends ClockAdapter {
    private final double _width;
    private final double _height;
    private Point2D _position;
    private double _orientation;
    private final ArrayList<ExampleModelElementListener> _listeners;

    public ExampleModelElement(double d, double d2, Point2D point2D, double d3) {
        this._width = d;
        this._height = d2;
        this._position = new Point2D.Double(point2D.getX(), point2D.getY());
        this._orientation = d3;
        this._listeners = new ArrayList();
    }

    public double getWidth() {
        return this._width;
    }

    public double getHeight() {
        return this._height;
    }

    public Point2D getPositionReference() {
        return this._position;
    }

    public void setPosition(Point2D point2D) {
        if (!point2D.equals(this._position)) {
            this._position.setLocation(point2D);
            this.notifyPositionChanged();
        }
    }

    public double getOrientation() {
        return this._orientation;
    }

    public void setOrientation(double d) {
        if (d != this._orientation) {
            this._orientation = d;
            this.notifyOrientationChanged();
        }
    }

    private void notifyPositionChanged() {
        Iterator<ExampleModelElementListener> iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().positionChanged();
        }
    }

    private void notifyOrientationChanged() {
        Iterator<ExampleModelElementListener> iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().orientationChanged();
        }
    }

    public void addExampleModelElementListener(ExampleModelElementListener exampleModelElementListener) {
        this._listeners.add(exampleModelElementListener);
    }

    public void simulationTimeChanged(ClockEvent clockEvent) {
        double d = 1.0;
        double d2 = PolarCartesianConverter.getX(d, this._orientation);
        double d3 = PolarCartesianConverter.getY(d, this._orientation);
        Point2D point2D = this.getPositionReference();
        Point2D.Double double_ = new Point2D.Double(point2D.getX() + d2, point2D.getY() + d3);
        this.setPosition(double_);
    }

    public static interface ExampleModelElementListener {
        public void positionChanged();

        public void orientationChanged();
    }
}

