/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.simexample.control;

import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.simexample.SimExampleStrings;
import edu.colorado.phet.simexample.model.ExampleModelElement;
import java.awt.geom.Point2D;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ExampleSubPanel
extends JPanel {
    private JLabel positionDisplay;
    private LinearValueControl orientationControl;

    public ExampleSubPanel(final ExampleModelElement exampleModelElement) {
        JLabel jLabel = new JLabel(SimExampleStrings.TITLE_EXAMPLE_CONTROL_PANEL);
        this.positionDisplay = new JLabel();
        double d = 0.0;
        double d2 = 360.0;
        String string = SimExampleStrings.LABEL_ORIENTATION;
        String string2 = "##0";
        String string3 = SimExampleStrings.UNITS_ORIENTATION;
        this.orientationControl = new LinearValueControl(d, d2, string, string2, string3);
        this.orientationControl.setValue(Math.toDegrees(exampleModelElement.getOrientation()));
        this.orientationControl.setTextFieldEditable(true);
        this.orientationControl.setUpDownArrowDelta(1.0);
        this.orientationControl.setTickPattern("0");
        this.orientationControl.setMajorTickSpacing(90.0);
        this.orientationControl.setMinorTickSpacing(45.0);
        this.orientationControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                exampleModelElement.setOrientation(Math.toRadians(ExampleSubPanel.this.orientationControl.getValue()));
            }
        });
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(this);
        this.setLayout(easyGridBagLayout);
        easyGridBagLayout.setAnchor(17);
        easyGridBagLayout.setFill(2);
        int n = 0;
        int n2 = 0;
        easyGridBagLayout.addComponent(jLabel, n++, n2);
        easyGridBagLayout.addComponent(this.positionDisplay, n++, n2);
        easyGridBagLayout.addComponent(this.orientationControl, n++, n2);
        exampleModelElement.addExampleModelElementListener(new ExampleModelElement.ExampleModelElementListener(){

            public void orientationChanged() {
                ExampleSubPanel.this.setOrientation(Math.toDegrees(exampleModelElement.getOrientation()));
            }

            public void positionChanged() {
                ExampleSubPanel.this.setPosition(exampleModelElement.getPositionReference());
            }
        });
    }

    private void setOrientation(double d) {
        this.orientationControl.setValue(d);
    }

    private void setPosition(Point2D point2D) {
        String string = SimExampleStrings.LABEL_POSITION + " (" + (int)point2D.getX() + "," + (int)point2D.getY() + ")";
        this.positionDisplay.setText(string);
    }
}

