/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.simexample;

import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.util.persistence.XMLPersistenceManager;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.menu.OptionsMenu;
import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import edu.colorado.phet.common.piccolophet.PiccoloPhetApplication;
import edu.colorado.phet.simexample.SimExampleStrings;
import edu.colorado.phet.simexample.module.example.ExampleModule;
import edu.colorado.phet.simexample.persistence.ExampleConfig;
import edu.colorado.phet.simexample.persistence.SimExampleConfig;
import java.awt.Frame;
import javax.swing.JMenu;

public class SimExampleApplication
extends PiccoloPhetApplication {
    private ExampleModule exampleModule;
    private XMLPersistenceManager persistenceManager;

    public SimExampleApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        this.initModules();
        this.initMenubar();
    }

    private void initModules() {
        PhetFrame phetFrame = this.getPhetFrame();
        this.exampleModule = this.getFirstModule(phetFrame);
        this.addModule(this.exampleModule);
        ExampleModule exampleModule = new ExampleModule(phetFrame);
        exampleModule.setName(SimExampleStrings.TITLE_ANOTHER_EXAMPLE_MODULE);
        this.addModule(exampleModule);
    }

    protected ExampleModule getFirstModule(Frame frame) {
        return new ExampleModule(frame);
    }

    private void initMenubar() {
        OptionsMenu optionsMenu;
        PhetFrame phetFrame = this.getPhetFrame();
        phetFrame.addFileSaveLoadMenuItems();
        if (this.persistenceManager == null) {
            this.persistenceManager = new XMLPersistenceManager(phetFrame);
        }
        if ((optionsMenu = new OptionsMenu()).getMenuComponentCount() > 0) {
            phetFrame.addMenu(optionsMenu);
        }
        JMenu jMenu = phetFrame.getDeveloperMenu();
    }

    public void save() {
        SimExampleConfig simExampleConfig = new SimExampleConfig();
        simExampleConfig.setVersionString(this.getSimInfo().getVersion().toString());
        simExampleConfig.setVersionMajor(this.getSimInfo().getVersion().getMajor());
        simExampleConfig.setVersionMinor(this.getSimInfo().getVersion().getMinor());
        simExampleConfig.setVersionDev(this.getSimInfo().getVersion().getDev());
        simExampleConfig.setVersionRevision(this.getSimInfo().getVersion().getRevision());
        ExampleConfig exampleConfig = this.exampleModule.save();
        simExampleConfig.setExampleConfig(exampleConfig);
        this.persistenceManager.save(simExampleConfig);
    }

    public void load() {
        Object object = this.persistenceManager.load();
        if (object != null) {
            if (object instanceof SimExampleConfig) {
                SimExampleConfig simExampleConfig = (SimExampleConfig)object;
                ExampleConfig exampleConfig = simExampleConfig.getExampleConfig();
                this.exampleModule.load(exampleConfig);
            } else {
                String string = SimExampleStrings.MESSAGE_NOT_A_CONFIG;
                PhetOptionPane.showErrorDialog(this.getPhetFrame(), string);
            }
        }
    }

    public static void main(String[] stringArray) throws ClassNotFoundException {
        new PhetApplicationLauncher().launchSim(stringArray, "sim-example", SimExampleApplication.class);
    }
}

