/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.controls;

import edu.colorado.phet.common.phetcommon.dialogs.ColorChooserFactory;
import edu.colorado.phet.common.phetcommon.view.HorizontalLayoutPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.MouseInputAdapter;

public class ColorControl
extends HorizontalLayoutPanel
implements ColorChooserFactory.Listener {
    private static final Dimension DEFAULT_CHIP_SIZE = new Dimension(15, 15);
    private static final Stroke CHIP_STROKE = new BasicStroke(1.0f);
    private static final Color CHIP_STROKE_COLOR = Color.BLACK;
    private Frame parentFrame;
    private String labelString;
    private JLabel colorChip;
    private Dimension chipSize;
    private Color color;
    private JDialog colorChooserDialog;
    private EventListenerList listenerList;

    public ColorControl(Frame frame, String string, Color color) {
        this(frame, string, color, DEFAULT_CHIP_SIZE);
    }

    public ColorControl(Frame frame, String string, Color color, Dimension dimension) {
        this.parentFrame = frame;
        this.labelString = string;
        this.color = color;
        this.chipSize = new Dimension(dimension);
        this.listenerList = new EventListenerList();
        JLabel jLabel = new JLabel(string);
        this.colorChip = new JLabel();
        this.setColor(color);
        this.colorChip.addMouseListener(new MouseInputAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getSource() instanceof JLabel) {
                    ColorControl.this.openColorChooser();
                }
            }
        });
        this.add(jLabel);
        this.add(Box.createHorizontalStrut(5));
        this.add(this.colorChip);
    }

    public void setColor(Color color) {
        this.color = color;
        this.updateColorChip(color);
        this.fireChangeEvent(new ChangeEvent(this));
    }

    public Color getColor() {
        return this.color;
    }

    private void updateColorChip(Color color) {
        Rectangle rectangle = new Rectangle(0, 0, this.chipSize.width, this.chipSize.height);
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(color);
        graphics2D.fill(rectangle);
        graphics2D.setStroke(CHIP_STROKE);
        graphics2D.setColor(CHIP_STROKE_COLOR);
        graphics2D.draw(rectangle);
        this.colorChip.setIcon(new ImageIcon(bufferedImage));
    }

    private void openColorChooser() {
        this.closeColorChooser();
        this.colorChooserDialog = ColorChooserFactory.createDialog(this.labelString, this.parentFrame, this.color, this);
        this.colorChooserDialog.show();
    }

    private void closeColorChooser() {
        if (this.colorChooserDialog != null) {
            this.colorChooserDialog.dispose();
        }
    }

    public void colorChanged(Color color) {
        this.setColor(color);
    }

    public void ok(Color color) {
        this.setColor(color);
    }

    public void cancelled(Color color) {
        this.setColor(color);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    private void fireChangeEvent(ChangeEvent changeEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }
}

