/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.signalcircuit.phys2d;

import java.util.Vector;

public class DoublePoint {
    double x;
    double y;

    public DoublePoint() {
        this(0.0, 0.0);
    }

    public String toString() {
        Vector<Double> vector = new Vector<Double>();
        vector.add(new Double(this.x));
        vector.add(new Double(this.y));
        return vector.toString();
    }

    public double length() {
        return this.getLength();
    }

    public double getLength() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public DoublePoint(double d, double d2) {
        this.x = d;
        this.y = d2;
        if (Double.isNaN(d)) {
            throw new RuntimeException("x was NaN");
        }
        if (Double.isNaN(d2)) {
            throw new RuntimeException("Y was NaN");
        }
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public DoublePoint add(DoublePoint doublePoint) {
        return new DoublePoint(this.x + doublePoint.x, this.y + doublePoint.y);
    }

    public DoublePoint normalize() {
        double d = this.getLength();
        return this.multiply(1.0 / d);
    }

    public DoublePoint multiply(double d) {
        return new DoublePoint(this.x * d, this.y * d);
    }

    public DoublePoint subtract(DoublePoint doublePoint) {
        return new DoublePoint(this.x - doublePoint.x, this.y - doublePoint.y);
    }
}

