/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.signalcircuit.paint.vector;

import edu.colorado.phet.signalcircuit.paint.vector.VectorPainter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class DefaultVectorPainter
implements VectorPainter {
    Color c;
    Stroke stroke;
    double theta;
    double tipLength;

    public DefaultVectorPainter(Color color, Stroke stroke) {
        this(color, stroke, 0.39269908169872414, 10.0);
    }

    public DefaultVectorPainter(Color color, Stroke stroke, double d, double d2) {
        this.c = color;
        this.stroke = stroke;
        this.theta = d;
        this.tipLength = d2;
    }

    public void paint(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        graphics2D.setStroke(this.stroke);
        graphics2D.setColor(this.c);
        graphics2D.drawLine(n, n2, n + n3, n2 + n4);
        if (n3 == 0 && n4 == 0) {
            return;
        }
        double d = Math.atan2(n3, n4);
        double d2 = d + this.theta;
        double d3 = d - this.theta;
        double d4 = (double)(n + n3) - this.tipLength * Math.sin(d2);
        double d5 = (double)(n2 + n4) - this.tipLength * Math.cos(d2);
        double d6 = (double)(n + n3) - this.tipLength * Math.sin(d3);
        double d7 = (double)(n2 + n4) - this.tipLength * Math.cos(d3);
        graphics2D.drawLine(n + n3, n2 + n4, (int)d4, (int)d5);
        graphics2D.drawLine(n + n3, n2 + n4, (int)d6, (int)d7);
    }
}

