/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.signalcircuit.paint.animate.twinkles;

import edu.colorado.phet.signalcircuit.paint.Painter;
import edu.colorado.phet.signalcircuit.paint.animate.Animation;
import edu.colorado.phet.signalcircuit.paint.animate.PointSource;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;

public class RotatingTwinkle2
implements Painter,
Animation {
    int numFrames;
    PointSource ps;
    Stroke s;
    int frame;
    double rot;
    double maxWidth;
    double maxHeight;

    public RotatingTwinkle2(PointSource pointSource, Stroke stroke, int n, double d, double d2, double d3) {
        this.rot = d;
        this.numFrames = n;
        this.ps = pointSource;
        this.s = stroke;
        this.maxWidth = d2;
        this.maxHeight = d3;
    }

    public int numFrames() {
        return this.numFrames;
    }

    private double getFrameFraction() {
        return (double)this.frame / (double)this.numFrames;
    }

    public void paint(Graphics2D graphics2D) {
        if (this.frame > this.numFrames) {
            return;
        }
        double d = this.getFrameFraction();
        int n = (int)(Math.sin(d * Math.PI) * this.maxHeight);
        int n2 = (int)(Math.sin(d * Math.PI) * this.maxWidth);
        Point point = this.ps.getPoint();
        int n3 = point.x;
        int n4 = point.y;
        int n5 = 10;
        graphics2D.setColor(Color.white);
        graphics2D.setStroke(this.s);
        double d2 = 1.5707963267948966 * (double)this.frame / (double)this.numFrames;
        graphics2D.drawLine(n3, n4, n3 + (int)((double)n2 * Math.cos(d2 * this.rot)), n4 + (int)((double)n * Math.sin(d2 * this.rot)));
        graphics2D.drawLine(n3, n4, n3 - (int)((double)n2 * Math.cos(d2 * this.rot)), n4 - (int)((double)n * Math.sin(d2 * this.rot)));
        graphics2D.drawLine(n3, n4, n3 - (int)((double)n2 * Math.sin(-d2 * this.rot)), n4 - (int)((double)n * Math.cos(-d2 * this.rot)));
        graphics2D.drawLine(n3, n4, n3 + (int)((double)n2 * Math.sin(-d2 * this.rot)), n4 + (int)((double)n * Math.cos(-d2 * this.rot)));
    }

    public Painter frameAt(int n) {
        this.frame = n;
        return this;
    }
}

