/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.signalcircuit.paint.animate.laws;

import edu.colorado.phet.signalcircuit.paint.LayeredPanel;
import edu.colorado.phet.signalcircuit.paint.Painter;
import edu.colorado.phet.signalcircuit.paint.animate.Animation;
import edu.colorado.phet.signalcircuit.phys2d.Law;
import edu.colorado.phet.signalcircuit.phys2d.System2D;
import java.awt.Graphics2D;

public class AnimateLaw
implements Painter,
Law {
    double dt;
    Animation a;
    Painter current;
    LayeredPanel paintMe;
    double simulationTime = 0.0;
    int numFrames;
    int layer;

    public AnimateLaw(double d, Animation animation, LayeredPanel layeredPanel, int n) {
        this.layer = n;
        this.numFrames = animation.numFrames();
        this.paintMe = layeredPanel;
        this.dt = d;
        this.a = animation;
        this.current = null;
    }

    public void paint(Graphics2D graphics2D) {
        if (this.current != null) {
            this.current.paint(graphics2D);
        }
    }

    public void iterate(double d, System2D system2D) {
        int n = (int)(this.simulationTime / this.dt);
        this.simulationTime += d;
        int n2 = (int)(this.simulationTime / this.dt);
        if (n == n2) {
            return;
        }
        if (n2 > this.numFrames) {
            system2D.remove(this);
            this.paintMe.remove(this, this.layer);
        } else {
            if (n2 >= this.numFrames) {
                return;
            }
            this.current = this.a.frameAt(n2);
            this.paintMe.repaint();
        }
    }
}

