/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.signalcircuit.electron.wire1d.paint;

import edu.colorado.phet.signalcircuit.electron.wire1d.WireParticle;
import edu.colorado.phet.signalcircuit.electron.wire1d.WirePatch;
import edu.colorado.phet.signalcircuit.electron.wire1d.WireSystem;
import edu.colorado.phet.signalcircuit.paint.Painter;
import edu.colorado.phet.signalcircuit.phys2d.DoublePoint;
import edu.colorado.phet.signalcircuit.phys2d.Particle;
import java.awt.Graphics2D;

public class WireParticlePainter
implements Painter {
    WireSystem ws;
    WirePatch converter;

    public WireParticlePainter(WireSystem wireSystem, WirePatch wirePatch) {
        this.ws = wireSystem;
        this.converter = wirePatch;
    }

    public void paint(Graphics2D graphics2D) {
        for (int i = 0; i < this.ws.numParticles(); ++i) {
            this.paint(this.ws.particleAt(i), graphics2D);
        }
    }

    public void paint(WireParticle wireParticle, Graphics2D graphics2D) {
        DoublePoint doublePoint = this.converter.getPosition(wireParticle.getPosition());
        if (doublePoint == null) {
            return;
        }
        Particle particle = new Particle();
        particle.setPosition(doublePoint);
        wireParticle.getPainter().paint(particle, graphics2D);
    }
}

