/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.signalcircuit.electron.wire1d;

import edu.colorado.phet.signalcircuit.phys2d.DoublePoint;

public class WireSegment {
    DoublePoint start;
    DoublePoint finish;
    double length;
    double scalarStart;
    double scalarFinish;

    public WireSegment(DoublePoint doublePoint, DoublePoint doublePoint2, double d) {
        this.start = doublePoint;
        this.finish = doublePoint2;
        this.start = doublePoint;
        this.length = doublePoint2.subtract(doublePoint).length();
        this.scalarStart = d;
        this.scalarFinish = d + this.length;
    }

    public void setFinish(DoublePoint doublePoint) {
        this.finish = doublePoint;
    }

    public DoublePoint getStart() {
        return this.start;
    }

    public double getFinishScalar() {
        return this.scalarFinish;
    }

    public String toString() {
        return "Start=" + this.start + ", finish=" + this.finish + ", length=" + this.length + ", scalarStart=" + this.scalarStart + ", scalarFinish=" + this.scalarFinish;
    }

    public DoublePoint getFinish() {
        return this.finish;
    }

    public boolean contains(double d) {
        return d >= this.scalarStart && d <= this.scalarFinish;
    }

    public DoublePoint getPosition(double d) {
        double d2 = d - this.scalarStart;
        DoublePoint doublePoint = this.finish.subtract(this.start).normalize();
        return doublePoint.multiply(d2).add(this.start);
    }

    public double length() {
        return this.length;
    }
}

