/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.signalcircuit.electron.wire1d;

import edu.colorado.phet.signalcircuit.electron.wire1d.WireSegment;
import edu.colorado.phet.signalcircuit.phys2d.DoublePoint;
import java.util.Vector;

public class WirePatch {
    Vector segments = new Vector();

    public double getLength() {
        return this.segmentAt(this.segments.size() - 1).getFinishScalar();
    }

    public void add(WireSegment wireSegment) {
        this.segments.add(wireSegment);
    }

    public DoublePoint getPosition(double d) {
        double d2 = this.getLength();
        while (d > d2) {
            d -= d2;
        }
        while (d < 0.0) {
            d += d2;
        }
        for (int i = 0; i < this.numSegments(); ++i) {
            if (!this.segmentAt(i).contains(d)) continue;
            return this.segmentAt(i).getPosition(d);
        }
        return null;
    }

    public DoublePoint getEndPoint() {
        if (this.segments.size() == 0) {
            throw new RuntimeException("No wires specified.");
        }
        DoublePoint doublePoint = this.segmentAt(this.segments.size() - 1).getFinish();
        return doublePoint;
    }

    public void addRelative(double d, double d2) {
        DoublePoint doublePoint = this.getEndPoint();
        this.add(doublePoint.getX() + d, d2 + doublePoint.getY());
    }

    public void add(double d, double d2) {
        if (this.segments.size() == 0) {
            throw new RuntimeException("No wires specified.");
        }
        DoublePoint doublePoint = this.segmentAt(this.segments.size() - 1).getFinish();
        DoublePoint doublePoint2 = new DoublePoint(d, d2);
        double d3 = this.totalDistance();
        this.add(new WireSegment(doublePoint, doublePoint2, d3));
    }

    public void add(double d, double d2, double d3, double d4) {
        if (this.segments.size() != 0) {
            throw new RuntimeException("Already started.");
        }
        DoublePoint doublePoint = new DoublePoint(d, d2);
        DoublePoint doublePoint2 = doublePoint.add(new DoublePoint(d3, d4));
        this.add(new WireSegment(doublePoint, doublePoint2, 0.0));
    }

    public double totalDistance() {
        double d = 0.0;
        for (int i = 0; i < this.numSegments(); ++i) {
            d += this.segmentAt(i).length();
        }
        return d;
    }

    public int numSegments() {
        return this.segments.size();
    }

    public WireSegment getLastSegment() {
        return this.segmentAt(this.numSegments() - 1);
    }

    public WireSegment segmentAt(int n) {
        return (WireSegment)this.segments.get(n);
    }
}

