/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.signalcircuit;

import edu.colorado.phet.signalcircuit.SwitchListener;
import edu.colorado.phet.signalcircuit.electron.wire1d.Force1d;
import edu.colorado.phet.signalcircuit.electron.wire1d.WireParticle;
import edu.colorado.phet.signalcircuit.electron.wire1d.WirePatch;
import edu.colorado.phet.signalcircuit.electron.wire1d.WireSystem;

public class WraparoundForce
implements SwitchListener,
Force1d {
    double k;
    double power;
    WireSystem sys;
    double minDist;
    double maxDist;
    WirePatch patch;
    boolean closed = false;

    public WraparoundForce(double d, double d2, WireSystem wireSystem, WirePatch wirePatch) {
        this.patch = wirePatch;
        this.sys = wireSystem;
        this.k = d;
        this.power = d2;
        this.maxDist = Double.POSITIVE_INFINITY;
    }

    public void setSwitchClosed(boolean bl) {
        this.closed = bl;
    }

    public void setMinDistance(double d) {
        this.minDist = d;
    }

    public void setMaxDistance(double d) {
        this.maxDist = d;
    }

    public double getPositionDifference(double d, double d2, double d3) {
        if (!this.closed) {
            return d - d2;
        }
        double d4 = Math.abs(d - d2);
        double d5 = Math.abs(d - d2 + d3);
        double d6 = Math.abs(d - d2 - d3);
        double d7 = Math.min(d4, d5);
        if ((d7 = Math.min(d6, d7)) == d4) {
            return d - d2;
        }
        if (d7 == d5) {
            return d - d2 + d3;
        }
        return d - d2 - d3;
    }

    public double getForce(WireParticle wireParticle) {
        double d = 0.0;
        for (int i = 0; i < this.sys.numParticles(); ++i) {
            WireParticle wireParticle2 = this.sys.particleAt(i);
            if (wireParticle2 == wireParticle) continue;
            double d2 = this.getPositionDifference(wireParticle2.getPosition(), wireParticle.getPosition(), this.patch.getLength());
            double d3 = Math.abs(d2);
            if (d3 < this.minDist) {
                d3 = this.minDist;
            }
            double d4 = 0.0;
            if (!(d3 > this.maxDist) || this.maxDist == 0.0) {
                d4 = this.k * Math.pow(d3, this.power);
                if (d2 > 0.0) {
                    d4 *= -1.0;
                }
            }
            d += d4;
        }
        return d;
    }
}

