/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.signalcircuit;

import edu.colorado.phet.signalcircuit.electron.wire1d.Force1d;
import edu.colorado.phet.signalcircuit.electron.wire1d.Propagator1d;
import edu.colorado.phet.signalcircuit.electron.wire1d.WireParticle;
import edu.colorado.phet.signalcircuit.electron.wire1d.WirePatch;
import java.util.Vector;

public class SignalPropagator
implements Propagator1d {
    Vector forces = new Vector();
    double vMax;
    boolean switchClosed = false;
    WirePatch patch;

    public SignalPropagator(double d, WirePatch wirePatch) {
        this.patch = wirePatch;
        this.vMax = d;
    }

    public void setMaxVelocity(double d) {
        this.vMax = d;
    }

    public void addForce(Force1d force1d) {
        this.forces.add(force1d);
    }

    public void propagate(WireParticle wireParticle, double d) {
        double d2 = this.patch.totalDistance();
        double d3 = wireParticle.getMass();
        double d4 = wireParticle.getVelocity();
        double d5 = wireParticle.getPosition();
        double d6 = 0.0;
        for (int i = 0; i < this.forces.size(); ++i) {
            d6 += ((Force1d)this.forces.get(i)).getForce(wireParticle);
        }
        double d7 = d6 / d3;
        boolean bl = (d4 += d7 * d) >= 0.0;
        d4 = Math.abs(d4);
        d4 = Math.min(this.vMax, d4);
        if (!bl) {
            d4 *= -1.0;
        }
        double d8 = d5 += d4 * d;
        if (this.switchClosed) {
            if (d5 <= 0.0) {
                d8 = d2 - Math.abs(d5);
            } else if (d5 >= d2) {
                d8 = d5 - d2;
            }
        } else if (d5 < 0.0) {
            d8 = 0.0;
            d4 = 0.0;
        } else if (d5 >= d2) {
            d8 = d2;
            d4 = 0.0;
        }
        wireParticle.setVelocity(d4);
        wireParticle.setPosition(d8);
    }
}

