/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.signalcircuit;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.signalcircuit.Arrow;
import edu.colorado.phet.signalcircuit.BatteryForce;
import edu.colorado.phet.signalcircuit.Chandelier;
import edu.colorado.phet.signalcircuit.ClosedPropagator;
import edu.colorado.phet.signalcircuit.ElectronPainter;
import edu.colorado.phet.signalcircuit.Friction;
import edu.colorado.phet.signalcircuit.InsidePropagator;
import edu.colorado.phet.signalcircuit.RegionSelector;
import edu.colorado.phet.signalcircuit.SegmentAngle;
import edu.colorado.phet.signalcircuit.SelectableArrow;
import edu.colorado.phet.signalcircuit.SelectablePainter;
import edu.colorado.phet.signalcircuit.ShowElectrons;
import edu.colorado.phet.signalcircuit.SignalCircuitResources;
import edu.colorado.phet.signalcircuit.SignalCircuitStrings;
import edu.colorado.phet.signalcircuit.SignalPropagator;
import edu.colorado.phet.signalcircuit.SignalPropagator3;
import edu.colorado.phet.signalcircuit.Switch;
import edu.colorado.phet.signalcircuit.SwitchCloser;
import edu.colorado.phet.signalcircuit.SwitchCover;
import edu.colorado.phet.signalcircuit.WraparoundForce;
import edu.colorado.phet.signalcircuit.electron.wire1d.WireParticle;
import edu.colorado.phet.signalcircuit.electron.wire1d.WirePatch;
import edu.colorado.phet.signalcircuit.electron.wire1d.WireSegment;
import edu.colorado.phet.signalcircuit.electron.wire1d.WireSystem;
import edu.colorado.phet.signalcircuit.electron.wire1d.paint.WireParticlePainter;
import edu.colorado.phet.signalcircuit.electron.wire1d.paint.WirePatchPainter;
import edu.colorado.phet.signalcircuit.electron.wire1d.propagators.CompositePropagator1d;
import edu.colorado.phet.signalcircuit.electron.wire1d.propagators.ForcePropagator;
import edu.colorado.phet.signalcircuit.electron.wire1d.propagators.WireEndPropagator;
import edu.colorado.phet.signalcircuit.paint.BufferedImagePainter;
import edu.colorado.phet.signalcircuit.paint.FilledRectanglePainter;
import edu.colorado.phet.signalcircuit.paint.LayeredPanel;
import edu.colorado.phet.signalcircuit.paint.animate.Movie;
import edu.colorado.phet.signalcircuit.paint.animate.laws.AnimateAdder;
import edu.colorado.phet.signalcircuit.paint.animate.laws.AnimateLaw;
import edu.colorado.phet.signalcircuit.paint.animate.twinkles.RotatingTwinkle2;
import edu.colorado.phet.signalcircuit.paint.particle.ImagePainter;
import edu.colorado.phet.signalcircuit.phys2d.DoublePoint;
import edu.colorado.phet.signalcircuit.phys2d.System2D;
import edu.colorado.phet.signalcircuit.phys2d.laws.Repaint;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JApplet;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeListener;

public class Signal
extends JApplet {
    LayeredPanel panel;
    System2D sys;
    JPanel controlPanel;

    public JPanel getControlPanel() {
        return this.controlPanel;
    }

    public System2D getSystem() {
        return this.sys;
    }

    public LayeredPanel getPanel() {
        return this.panel;
    }

    public Signal(int n, int n2, IClock iClock) {
        Object object;
        BufferedImage bufferedImage = SignalCircuitResources.loadBufferedImage("electron9.gif");
        BufferedImage bufferedImage2 = SignalCircuitResources.loadBufferedImage("PhetBattery1.gif");
        bufferedImage = BufferedImageUtils.multiScaleToHeight(bufferedImage, 20);
        ImagePainter imagePainter = new ImagePainter(bufferedImage);
        BufferedImage bufferedImage3 = SignalCircuitResources.loadBufferedImage("Electron3VX.GIF");
        bufferedImage3 = BufferedImageUtils.multiScaleToHeight(bufferedImage3, 20);
        ImagePainter imagePainter2 = new ImagePainter(bufferedImage3);
        this.panel = new LayeredPanel();
        this.panel.addPainter(new FilledRectanglePainter(0, 0, 800, 800, Color.white));
        BasicStroke basicStroke = new BasicStroke((int)((double)bufferedImage.getWidth() * 1.2));
        DoublePoint doublePoint = new DoublePoint(100.0, n2 / 2 + 50);
        WirePatch wirePatch = new WirePatch();
        double d = 150.0;
        int n3 = 80;
        int n4 = 50;
        wirePatch.add(doublePoint.getX(), doublePoint.getY(), -n4, 0.0);
        wirePatch.addRelative(0.0, -d);
        wirePatch.addRelative(n, 0.0);
        wirePatch.addRelative(0.0, d);
        wirePatch.addRelative(-n + n4 + n3, 0.0);
        wirePatch.addRelative(-n3, 0.0);
        WirePatchPainter wirePatchPainter = new WirePatchPainter(basicStroke, Color.gray, wirePatch);
        this.panel.addPainter(wirePatchPainter);
        WireSegment wireSegment = wirePatch.getLastSegment();
        this.sys = new System2D();
        WireSystem wireSystem = new WireSystem();
        this.sys.addLaw(wireSystem);
        double d2 = 300000.0;
        WraparoundForce wraparoundForce = new WraparoundForce(d2, -2.2, wireSystem, wirePatch);
        wraparoundForce.setMinDistance(3.0);
        wraparoundForce.setMaxDistance(100.0);
        int n5 = 52;
        SignalPropagator signalPropagator = new SignalPropagator(100.0, wirePatch);
        RegionSelector regionSelector = new RegionSelector();
        regionSelector.addRegion(0.0, wirePatch.getLength(), new Friction(0.6));
        double d3 = wirePatch.totalDistance();
        regionSelector.addRegion(0.0, wirePatch.totalDistance(), signalPropagator);
        signalPropagator.setMaxVelocity(30.0);
        signalPropagator.addForce(wraparoundForce);
        double d4 = d3 / (double)n5;
        int n6 = 150;
        int n7 = 150;
        int n8 = 10;
        CompositePropagator1d compositePropagator1d = new CompositePropagator1d();
        double d5 = 90.0;
        ForcePropagator forcePropagator = new ForcePropagator(d5);
        double d6 = 1.5 * d2;
        double d7 = -2.0;
        WraparoundForce wraparoundForce2 = new WraparoundForce(d6, d7, wireSystem, wirePatch);
        wraparoundForce2.setMinDistance(5.0);
        wraparoundForce2.setMaxDistance(80.0);
        forcePropagator.addForce(wraparoundForce);
        double d8 = 2500.0;
        double d9 = 1100.0;
        double d10 = 1200.0;
        int n9 = 20;
        BatteryForce batteryForce = new BatteryForce(d8, d9, d10, wireSystem, n9);
        this.sys.addLaw(batteryForce);
        forcePropagator.addForce(batteryForce);
        double d11 = 100.0;
        ForcePropagator forcePropagator2 = new ForcePropagator(d11);
        forcePropagator2.addForce(wraparoundForce2);
        compositePropagator1d.addPropagator(forcePropagator);
        compositePropagator1d.addPropagator(new Friction(0.6));
        compositePropagator1d.addPropagator(new WireEndPropagator(wirePatch));
        CompositePropagator1d compositePropagator1d2 = new CompositePropagator1d();
        compositePropagator1d2.addPropagator(new InsidePropagator(n8, wirePatch));
        CompositePropagator1d compositePropagator1d3 = new CompositePropagator1d();
        ClosedPropagator closedPropagator = new ClosedPropagator(wirePatch, compositePropagator1d2, compositePropagator1d3, n7, n6);
        SignalPropagator3 signalPropagator3 = new SignalPropagator3(compositePropagator1d, closedPropagator, false);
        compositePropagator1d2.addPropagator(forcePropagator2);
        this.sys.addLaw(closedPropagator);
        for (int i = 0; i < n5; ++i) {
            object = new WireParticle(imagePainter, signalPropagator3);
            ((WireParticle)object).setPosition((double)i * d4);
            wireSystem.add((WireParticle)object);
        }
        JSlider jSlider = new JSlider(0, 90, 45);
        jSlider.setMajorTickSpacing(9);
        jSlider.setPaintTicks(true);
        jSlider.setBorder(BorderFactory.createTitledBorder(SignalCircuitStrings.getString("Signal.SwitchSlider")));
        object = new SegmentAngle(jSlider, wireSegment);
        SwitchCloser switchCloser = new SwitchCloser(0.15707963267948966);
        switchCloser.addSwitchListener(closedPropagator);
        switchCloser.addSwitchListener(signalPropagator3);
        switchCloser.addSwitchListener(wraparoundForce);
        switchCloser.addSwitchListener(wraparoundForce2);
        ((SegmentAngle)object).addAngleListener(switchCloser);
        ((SegmentAngle)object).stateChanged(null);
        jSlider.addChangeListener((ChangeListener)object);
        WireParticlePainter wireParticlePainter = new WireParticlePainter(wireSystem, wirePatch);
        JCheckBox jCheckBox = new JCheckBox(SignalCircuitStrings.getString("Signal.ShowElectronsCheckBox"), true);
        ShowElectrons showElectrons = new ShowElectrons(jCheckBox, wireParticlePainter);
        this.panel.addPainter(showElectrons, 1);
        this.sys.addLaw(new Repaint(this.panel));
        iClock.addClockListener(new ClockAdapter(){

            public void simulationTimeChanged(ClockEvent clockEvent) {
                Signal.this.sys.iterate(clockEvent.getSimulationTimeChange());
            }
        });
        Signal signal = this;
        Point point = new Point(105, 110);
        Point point2 = new Point(105, 220);
        BufferedImage bufferedImage4 = SignalCircuitResources.loadBufferedImage("A.jpg");
        BufferedImage bufferedImage5 = SignalCircuitResources.loadBufferedImage("B.jpg");
        Switch switch_ = new Switch(new BufferedImagePainter(bufferedImage5, point.x, point.y), new BufferedImagePainter(bufferedImage4, point.x, point.y), false, jSlider);
        Switch switch_2 = new Switch(new BufferedImagePainter(bufferedImage5, point2.x, point2.y), new BufferedImagePainter(bufferedImage4, point2.x, point2.y), false, jSlider);
        JCheckBox jCheckBox2 = new JCheckBox(SignalCircuitStrings.getString("Signal.ShowInsideSwitchCheckBox"), false);
        SwitchCover switchCover = new SwitchCover(switch_, switch_2, true, jCheckBox2, signal.getPanel());
        switchCloser.addSwitchListener(switchCover);
        BufferedImage bufferedImage6 = SignalCircuitResources.loadBufferedImage("ChandelierOn2.jpg");
        BufferedImage bufferedImage7 = SignalCircuitResources.loadBufferedImage("ChandelierOff2.jpg");
        int n10 = 250;
        int n11 = 62;
        BufferedImagePainter bufferedImagePainter = new BufferedImagePainter(bufferedImage6, n10, n11);
        BufferedImagePainter bufferedImagePainter2 = new BufferedImagePainter(bufferedImage7, n10, n11);
        double d12 = 510.0;
        Chandelier chandelier = new Chandelier(bufferedImagePainter, bufferedImagePainter2, false, d12);
        this.panel.addPainter(chandelier, 2);
        closedPropagator.addSignalListener(chandelier);
        Arrow arrow = new Arrow(wirePatch);
        closedPropagator.addSignalListener(arrow);
        switchCloser.addSwitchListener(arrow);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(SignalCircuitStrings.getString("Signal.ComparisonToolsBorder")));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JCheckBox jCheckBox3 = new JCheckBox(SignalCircuitStrings.getString("Signal.ShowSignalArrowCheckBox"));
        JCheckBox jCheckBox4 = new JCheckBox(SignalCircuitStrings.getString("Signal.PaintElectronCheckBox"));
        jPanel.add(jCheckBox3);
        jPanel.add(jCheckBox4);
        SelectablePainter selectablePainter = new SelectablePainter(imagePainter, imagePainter2, false, jCheckBox4);
        jCheckBox4.addActionListener(selectablePainter);
        ElectronPainter electronPainter = new ElectronPainter(jCheckBox4, wireSystem, imagePainter, selectablePainter, this.panel, wirePatch);
        SelectableArrow selectableArrow = new SelectableArrow(jCheckBox3, arrow, this.panel);
        jCheckBox3.addActionListener(selectableArrow);
        this.panel.addPainter(selectableArrow, 11);
        switchCloser.addSwitchListener(closedPropagator);
        switchCloser.addSwitchListener(electronPainter);
        this.panel.addPainter(electronPainter, 10);
        signal.getPanel().addMouseListener(switchCover);
        jCheckBox2.addActionListener(switchCover);
        signal.getPanel().addPainter(switchCover, 9);
        signal.getPanel().addPainter(new BufferedImagePainter(bufferedImage2, 400, 175), 10);
        this.controlPanel = new JPanel();
        this.controlPanel.add(jCheckBox);
        this.controlPanel.add(jCheckBox2);
        this.controlPanel.add(jPanel);
        this.controlPanel.add((Component)jSlider, "South");
        Movie movie = new Movie();
        int n12 = 10;
        BasicStroke basicStroke2 = new BasicStroke(0.8f);
        RotatingTwinkle2 rotatingTwinkle2 = new RotatingTwinkle2(switchCover, basicStroke2, 20, 3.0, 8.0, 15.0);
        movie.addAnimation(rotatingTwinkle2);
        double d13 = 0.02;
        AnimateLaw animateLaw = new AnimateLaw(d13 * 2.5, movie, signal.getPanel(), n12);
        new Thread(new AnimateAdder(2000, animateLaw, signal.getSystem(), signal.getPanel(), n12)).start();
        animateLaw = new AnimateLaw(d13 * 2.5, movie, signal.getPanel(), n12);
        new Thread(new AnimateAdder(8000, animateLaw, signal.getSystem(), signal.getPanel(), n12)).start();
    }
}

