/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.signalcircuit;

import edu.colorado.phet.signalcircuit.SwitchListener;
import edu.colorado.phet.signalcircuit.electron.wire1d.WireParticle;
import edu.colorado.phet.signalcircuit.electron.wire1d.WirePatch;
import edu.colorado.phet.signalcircuit.electron.wire1d.WireSystem;
import edu.colorado.phet.signalcircuit.paint.Painter;
import edu.colorado.phet.signalcircuit.paint.particle.ParticlePainter;
import edu.colorado.phet.signalcircuit.paint.particle.ParticlePainterAdapter;
import edu.colorado.phet.signalcircuit.phys2d.DoublePoint;
import edu.colorado.phet.signalcircuit.phys2d.Particle;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;

public class ElectronPainter
implements SwitchListener,
Painter,
ActionListener {
    WireParticle taggedParticle;
    JCheckBox box;
    WireSystem ws;
    ParticlePainter normal;
    ParticlePainter tagged;
    Component paint;
    WirePatch wp;

    public ElectronPainter(JCheckBox jCheckBox, WireSystem wireSystem, ParticlePainter particlePainter, ParticlePainter particlePainter2, Component component, WirePatch wirePatch) {
        this.wp = wirePatch;
        this.box = jCheckBox;
        this.ws = wireSystem;
        this.normal = particlePainter;
        this.tagged = particlePainter2;
        this.paint = component;
    }

    public void paint(Graphics2D graphics2D) {
        if (this.taggedParticle != null && this.box.isSelected()) {
            double d;
            double d2 = this.taggedParticle.getPosition();
            if (d2 > (d = this.wp.getLength())) {
                d2 -= d;
            } else if (d2 < 0.0) {
                d2 += d;
            }
            DoublePoint doublePoint = this.wp.getPosition(d2);
            if (doublePoint == null) {
                System.out.println("TaggedParticle=" + this.taggedParticle + ", pt=" + d2 + ", wire length=" + d + ", draw=" + doublePoint);
                throw new RuntimeException("Set a null position.");
            }
            Particle particle = new Particle();
            particle.setPosition(doublePoint);
            new ParticlePainterAdapter(this.tagged, particle).paint(graphics2D);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.paint.repaint();
    }

    public void setSwitchClosed(boolean bl) {
        if (!bl) {
            if (this.taggedParticle != null) {
                this.taggedParticle.setPainter(this.normal);
            }
            this.taggedParticle = null;
        } else {
            double d = Double.MAX_VALUE;
            WireParticle wireParticle = null;
            for (int i = this.ws.numParticles() - 1; i >= 0; --i) {
                WireParticle wireParticle2 = this.ws.particleAt(i);
                if (!(wireParticle2.getPosition() <= d)) continue;
                d = wireParticle2.getPosition();
                wireParticle = wireParticle2;
            }
            this.taggedParticle = wireParticle;
        }
    }
}

