/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.signalcircuit;

import edu.colorado.phet.signalcircuit.SignalListener;
import edu.colorado.phet.signalcircuit.SwitchListener;
import edu.colorado.phet.signalcircuit.electron.wire1d.Propagator1d;
import edu.colorado.phet.signalcircuit.electron.wire1d.WireParticle;
import edu.colorado.phet.signalcircuit.electron.wire1d.WirePatch;
import edu.colorado.phet.signalcircuit.phys2d.Law;
import edu.colorado.phet.signalcircuit.phys2d.System2D;
import java.util.Vector;

public class ClosedPropagator
implements SwitchListener,
Propagator1d,
Law {
    boolean switchClosed;
    WirePatch patch;
    double fore;
    double back;
    Propagator1d inside;
    Propagator1d outside;
    double backSpeed;
    double foreSpeed;
    Vector list = new Vector();

    public ClosedPropagator(WirePatch wirePatch, Propagator1d propagator1d, Propagator1d propagator1d2, double d, double d2) {
        this.inside = propagator1d;
        this.outside = propagator1d2;
        this.backSpeed = d;
        this.foreSpeed = d2;
        this.patch = wirePatch;
    }

    public void setSwitchClosed(boolean bl) {
        this.switchClosed = bl;
        if (!bl) {
            this.fore = 0.0;
            this.back = this.patch.getLength();
        }
        this.notifyListeners();
    }

    public void addSignalListener(SignalListener signalListener) {
        this.list.add(signalListener);
    }

    public void iterate(double d, System2D system2D) {
        if (this.switchClosed) {
            this.fore += this.foreSpeed * d;
            this.back -= this.backSpeed * d;
        }
        this.notifyListeners();
    }

    public void notifyListeners() {
        for (int i = 0; i < this.list.size(); ++i) {
            ((SignalListener)this.list.get(i)).signalMoved(this.fore, this.back);
        }
    }

    public void propagate(WireParticle wireParticle, double d) {
        double d2 = wireParticle.getPosition();
        if (d2 <= this.fore || d2 >= this.back) {
            this.inside.propagate(wireParticle, d);
        } else {
            this.outside.propagate(wireParticle, d);
        }
    }
}

