/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.signalcircuit;

import edu.colorado.phet.signalcircuit.electron.wire1d.Force1d;
import edu.colorado.phet.signalcircuit.electron.wire1d.WireParticle;
import edu.colorado.phet.signalcircuit.electron.wire1d.WireSystem;
import edu.colorado.phet.signalcircuit.phys2d.Law;
import edu.colorado.phet.signalcircuit.phys2d.System2D;

public class BatteryForce
implements Force1d,
Law {
    double f;
    double min;
    double max;
    WireSystem ws;
    double numOver;
    double maxOver;

    public BatteryForce(double d, double d2, double d3, WireSystem wireSystem, double d4) {
        this.maxOver = d4;
        this.f = d;
        this.min = d2;
        this.max = d3;
        this.ws = wireSystem;
    }

    public void iterate(double d, System2D system2D) {
        int n = 0;
        for (int i = 0; i < this.ws.numParticles(); ++i) {
            if (!(this.ws.particleAt(i).getPosition() > this.min + this.max / 2.0 - this.min / 2.0)) continue;
            ++n;
        }
        this.numOver = n;
    }

    public double getForce(WireParticle wireParticle) {
        double d = this.max - this.min;
        double d2 = d / 2.0;
        double d3 = this.min + d2;
        double d4 = wireParticle.getPosition();
        if (d4 < this.min || d4 > this.max) {
            return 0.0;
        }
        double d5 = this.f;
        if (this.numOver >= this.maxOver) {
            d5 /= 3.0;
        }
        double d6 = Math.abs(d4 - d3);
        double d7 = -d5 / d2;
        double d8 = d7 * d6 + d5;
        return d8;
    }
}

