/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.signalcircuit;

import edu.colorado.phet.signalcircuit.SignalListener;
import edu.colorado.phet.signalcircuit.SwitchListener;
import edu.colorado.phet.signalcircuit.electron.wire1d.WirePatch;
import edu.colorado.phet.signalcircuit.paint.Painter;
import edu.colorado.phet.signalcircuit.paint.vector.DefaultVectorPainter;
import edu.colorado.phet.signalcircuit.paint.vector.VectorPainterAdapter;
import edu.colorado.phet.signalcircuit.phys2d.DoublePoint;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.Vector;

public class Arrow
implements SignalListener,
SwitchListener,
Painter {
    double fore;
    double back;
    WirePatch wp;
    boolean signalOn;
    Vector history = new Vector();
    VectorPainterAdapter arrow;
    VectorPainterAdapter arrow2;
    int historySize = 2;

    public Arrow(WirePatch wirePatch) {
        this.wp = wirePatch;
        DefaultVectorPainter defaultVectorPainter = new DefaultVectorPainter(Color.red, new BasicStroke(2.0f));
        this.arrow = new VectorPainterAdapter(defaultVectorPainter);
        BasicStroke basicStroke = new BasicStroke(2.0f, 0, 1, 5.0f, new float[]{2.0f, 2.0f}, 0.0f);
        DefaultVectorPainter defaultVectorPainter2 = new DefaultVectorPainter(Color.white, basicStroke);
        this.arrow2 = new VectorPainterAdapter(defaultVectorPainter2);
    }

    public void setSwitchClosed(boolean bl) {
        this.signalOn = bl;
        if (!this.signalOn) {
            this.history = new Vector();
        }
    }

    public synchronized void signalMoved(double d, double d2) {
        this.fore = d;
        this.back = d2;
    }

    public synchronized void paint(Graphics2D graphics2D) {
        double d = this.wp.getLength();
        while (this.fore >= d) {
            this.fore -= d;
        }
        DoublePoint doublePoint = this.wp.getPosition(this.fore);
        if (this.history.size() != 0) {
            DoublePoint doublePoint2 = (DoublePoint)this.history.get(0);
            if (this.fore == 0.0) {
                return;
            }
            Point point = new Point((int)doublePoint2.getX(), (int)doublePoint2.getY());
            int n = 20;
            DoublePoint doublePoint3 = doublePoint.subtract(doublePoint2);
            try {
                DoublePoint doublePoint4 = doublePoint3.normalize().multiply(n);
                Point point2 = new Point((int)doublePoint4.getX(), (int)doublePoint4.getY());
                VectorPainterAdapter vectorPainterAdapter = null;
                vectorPainterAdapter = this.back <= this.fore ? this.arrow2 : this.arrow;
                vectorPainterAdapter.setArrow(point.x, point.y, point2.x, point2.y);
                vectorPainterAdapter.paint(graphics2D);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.history.size() > this.historySize) {
            this.history.remove(0);
        }
        this.history.add(doublePoint);
    }
}

