/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.macro.energyprobe;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.semiconductor.common.SimpleBufferedImageGraphic;
import edu.colorado.phet.semiconductor.common.TransformGraphic;
import edu.colorado.phet.semiconductor.macro.energyprobe.Lead;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;

public class LeadGraphic
extends TransformGraphic
implements SimpleObserver {
    Lead lead;
    private BufferedImage image;
    SimpleBufferedImageGraphic graphic;

    public LeadGraphic(ModelViewTransform2D modelViewTransform2D, Lead lead, BufferedImage bufferedImage) {
        super(modelViewTransform2D);
        this.lead = lead;
        this.image = bufferedImage;
        this.graphic = new SimpleBufferedImageGraphic(bufferedImage);
        lead.addObserver(this);
        this.update();
    }

    public void update() {
        Vector2D vector2D = this.lead.getTipLocation();
        Point point = super.getTransform().modelToView(vector2D);
        Point point2 = new Point(point.x, this.image.getHeight() / 2 + point.y);
        this.graphic.setPosition(point2);
    }

    public void paint(Graphics2D graphics2D) {
        this.graphic.paint(graphics2D);
    }

    public Point getTail() {
        Shape shape = this.graphic.getShape();
        Rectangle rectangle = shape.getBounds();
        return new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height);
    }
}

