/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.macro.energy.statemodels;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.semiconductor.macro.energy.EnergySection;
import edu.colorado.phet.semiconductor.macro.energy.StateTransitionList;
import edu.colorado.phet.semiconductor.macro.energy.bands.Band;
import edu.colorado.phet.semiconductor.macro.energy.bands.EnergyCell;
import edu.colorado.phet.semiconductor.macro.energy.bands.SemiconductorBandSet;
import edu.colorado.phet.semiconductor.macro.energy.transitions.Move;

public class ExciteForConduction
implements ModelElement {
    private StateTransitionList list;
    private EnergySection energySection;
    private EnergyCell leftDst;
    private EnergyCell rightDst;

    public ExciteForConduction(EnergySection energySection, int n, int n2, int n3) {
        this.energySection = energySection;
        SemiconductorBandSet semiconductorBandSet = energySection.bandSetAt(n2);
        Band band = semiconductorBandSet.bandAt(n);
        Move move = this.getExciteTransition(band, n3, 0);
        Move move2 = this.getExciteTransition(band, n3, 1);
        this.leftDst = move.getDst();
        this.rightDst = move2.getDst();
        this.list = new StateTransitionList(energySection);
        this.list.addTransition(move);
        this.list.addTransition(move2);
    }

    private Move getExciteTransition(Band band, int n, int n2) {
        EnergyCell energyCell = band.energyLevelAt(n).cellAt(n2);
        this.leftDst = this.energySection.getUpperNeighbor(energyCell);
        Move move = new Move(energyCell, this.leftDst, this.energySection.getSpeed());
        return move;
    }

    public void stepInTime(double d) {
        this.list.stepInTime(d);
    }

    public EnergyCell getLeftCell() {
        return this.leftDst;
    }

    public EnergyCell getRightCell() {
        return this.rightDst;
    }
}

