/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.macro.energy.bands;

import edu.colorado.phet.semiconductor.macro.doping.DopantType;
import edu.colorado.phet.semiconductor.macro.energy.EnergySection;
import edu.colorado.phet.semiconductor.macro.energy.bands.Band;
import edu.colorado.phet.semiconductor.macro.energy.bands.BandDescriptor;
import edu.colorado.phet.semiconductor.macro.energy.bands.BandSet;
import edu.colorado.phet.semiconductor.macro.energy.bands.BandSetDescriptor;
import edu.colorado.phet.semiconductor.macro.energy.bands.EnergyCell;
import edu.colorado.phet.semiconductor.macro.energy.bands.EnergyLevel;
import java.util.Iterator;

public class SemiconductorBandSet
extends BandSet {
    private DopantType dopantType;
    private EnergySection dopantManager;

    public SemiconductorBandSet(BandSetDescriptor bandSetDescriptor, EnergySection energySection, int n) {
        for (int i = 0; i < bandSetDescriptor.numBands(); ++i) {
            BandDescriptor bandDescriptor = bandSetDescriptor.bandDescriptorAt(i);
            Band band = new Band(bandDescriptor.getRegion(), bandDescriptor.getNumLevels(), this, n);
            this.bands.add(band);
        }
        this.dopantManager = energySection;
    }

    public Band getConductionBand() {
        return this.bandAt(2);
    }

    public Band getValenceBand() {
        return this.bandAt(1);
    }

    public Band getBottomBand() {
        return this.bandAt(0);
    }

    public Band getTopBand() {
        return this.bandAt(3);
    }

    public EnergyLevelIterator energyLevelIterator() {
        return new EnergyLevelIterator();
    }

    public void trickDopantType(DopantType dopantType) {
        this.dopantType = dopantType;
    }

    public void setDopantType(DopantType dopantType) {
        this.dopantType = dopantType;
        EnergyLevelIterator energyLevelIterator = this.energyLevelIterator();
        while (energyLevelIterator.hasNext()) {
            EnergyLevel energyLevel = (EnergyLevel)energyLevelIterator.next();
            this.dopantManager.clear(energyLevel);
        }
        if (dopantType == null) {
            this.dopeLevels(this.getBottomBand(), 0, this.getBottomBand().numEnergyLevels(), this.getEnergySection());
            this.dopeLevels(this.getValenceBand(), 0, this.getBottomBand().numEnergyLevels(), this.getEnergySection());
        } else {
            this.dope();
        }
    }

    public void dope() {
        SemiconductorBandSet semiconductorBandSet = this;
        if (this.getDopantType() == DopantType.N) {
            this.dopeLevels(semiconductorBandSet.getBottomBand(), 0, semiconductorBandSet.getBottomBand().numEnergyLevels(), semiconductorBandSet.getEnergySection());
            this.dopeLevels(semiconductorBandSet.getValenceBand(), 0, semiconductorBandSet.getValenceBand().numEnergyLevels(), semiconductorBandSet.getEnergySection());
            this.dopeLevels(semiconductorBandSet.getConductionBand(), 0, this.getDopantType().getNumFilledLevels(), semiconductorBandSet.getEnergySection());
        } else if (this.getDopantType() == DopantType.P) {
            this.dopeLevels(semiconductorBandSet.getBottomBand(), 0, semiconductorBandSet.getBottomBand().numEnergyLevels(), semiconductorBandSet.getEnergySection());
            this.dopeLevels(semiconductorBandSet.getValenceBand(), 0, this.getDopantType().getNumFilledLevels(), semiconductorBandSet.getEnergySection());
        }
    }

    public void dopeLevels(Band band, int n, int n2, EnergySection energySection) {
        for (int i = n; i < n2; ++i) {
            energySection.fillLevel(band.energyLevelAt(i));
        }
    }

    public DopantType getDopantType() {
        return this.dopantType;
    }

    public EnergyCell energyCellAt(int n, int n2) {
        EnergyLevel energyLevel = this.levelAt(n);
        return energyLevel.cellAt(n2);
    }

    public EnergySection getEnergySection() {
        return this.dopantManager;
    }

    public class EnergyLevelIterator
    implements Iterator {
        int curBand;
        int curIndex;

        public boolean hasNext() {
            return this.curBand < SemiconductorBandSet.this.numBands();
        }

        public Object next() {
            return this.nextLevel();
        }

        public EnergyLevel nextLevel() {
            Band band = SemiconductorBandSet.this.bandAt(this.curBand);
            EnergyLevel energyLevel = band.energyLevelAt(this.curIndex);
            ++this.curIndex;
            if (this.curIndex >= band.numEnergyLevels()) {
                this.curIndex = 0;
                ++this.curBand;
            }
            return energyLevel;
        }

        public void remove() {
            throw new RuntimeException("Not supported.");
        }
    }
}

