/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.macro.energy.bands;

import edu.colorado.phet.semiconductor.common.EnergySpaceRegion;
import edu.colorado.phet.semiconductor.macro.energy.bands.Band;
import edu.colorado.phet.semiconductor.macro.energy.bands.BandSet;
import edu.colorado.phet.semiconductor.macro.energy.bands.EnergyCell;
import java.util.ArrayList;

public class EnergyLevel {
    private Band band;
    ArrayList cells = new ArrayList();
    private EnergySpaceRegion region;
    private static int ID = 0;
    private int id = ID++;

    public EnergyLevel(Band band, EnergySpaceRegion energySpaceRegion, int n) {
        this.band = band;
        this.region = energySpaceRegion;
        EnergyCell energyCell = new EnergyCell(this, energySpaceRegion.getMinX() + energySpaceRegion.getSpatialWidth() * 0.25, energySpaceRegion.getMinEnergy() + energySpaceRegion.getEnergyRange() / 2.0, n);
        EnergyCell energyCell2 = new EnergyCell(this, energySpaceRegion.getMinX() + energySpaceRegion.getSpatialWidth() * 0.75, energySpaceRegion.getMinEnergy() + energySpaceRegion.getEnergyRange() / 2.0, n + 1);
        this.cells.add(energyCell);
        this.cells.add(energyCell2);
    }

    public int numCells() {
        return this.cells.size();
    }

    public String toString() {
        return "id=" + this.id + ", index=" + this.band.indexOf(this);
    }

    public EnergySpaceRegion getRegion() {
        return this.region;
    }

    public EnergyCell cellAt(int n) {
        return (EnergyCell)this.cells.get(n);
    }

    public int indexOf(EnergyCell energyCell) {
        return this.cells.indexOf(energyCell);
    }

    public Band getBand() {
        return this.band;
    }

    public BandSet getBandSet() {
        return this.getBand().getBandSet();
    }

    public int getAbsoluteHeight() {
        return this.getBandSet().absoluteIndexOf(this);
    }

    public int getDistanceFromBottomLevelInBand() {
        return this.getBand().indexOf(this);
    }

    public int getID() {
        return this.id;
    }
}

