/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.macro.energy.bands;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.TransformListener;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.semiconductor.common.ClipGraphic;
import edu.colorado.phet.semiconductor.common.TransformGraphic;
import edu.colorado.phet.semiconductor.macro.energy.EnergySection;
import edu.colorado.phet.semiconductor.macro.energy.bands.BandGraphic;
import edu.colorado.phet.semiconductor.macro.energy.bands.ChargeCountGraphic;
import edu.colorado.phet.semiconductor.macro.energy.bands.EnergyLevel;
import edu.colorado.phet.semiconductor.macro.energy.bands.SemiconductorBandSet;
import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.CompositeInteractiveGraphic;
import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.ShapeGraphic;
import edu.colorado.phet.semiconductor.util.RectangleUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;

public class BandSetGraphic
extends TransformGraphic {
    CompositeInteractiveGraphic graphic = new CompositeInteractiveGraphic();
    ClipGraphic clipGraphic;
    ShapeGraphic backgroundWhite;
    ShapeGraphic backgroundBorder;
    private ChargeCountGraphic chargeCountGraphic;
    protected SemiconductorBandSet bandSet;
    private Rectangle2D.Double viewport;
    private boolean paintLevelIDs = false;

    public BandSetGraphic(EnergySection energySection, ModelViewTransform2D modelViewTransform2D, SemiconductorBandSet semiconductorBandSet, final Rectangle2D.Double double_) {
        super(modelViewTransform2D);
        this.bandSet = semiconductorBandSet;
        this.viewport = double_;
        this.backgroundWhite = new ShapeGraphic(double_, Color.white);
        this.backgroundBorder = new ShapeGraphic(double_, Color.blue, new BasicStroke(3.0f, 1, 1));
        modelViewTransform2D.addTransformListener(new TransformListener(){

            public void transformChanged(ModelViewTransform2D modelViewTransform2D) {
                Shape shape = BandSetGraphic.this.getTransform().getAffineTransform().createTransformedShape(double_);
                BandSetGraphic.this.backgroundWhite.setShape(shape);
                BandSetGraphic.this.backgroundBorder.setShape(shape);
            }
        });
        this.clipGraphic = new ClipGraphic(this.getTransform(), this.graphic, double_);
        BandGraphic bandGraphic = new BandGraphic(energySection, semiconductorBandSet.getConductionBand(), modelViewTransform2D);
        this.graphic.addGraphic(bandGraphic, 1.0);
        BandGraphic bandGraphic2 = new BandGraphic(energySection, semiconductorBandSet.getValenceBand(), modelViewTransform2D);
        this.graphic.addGraphic(bandGraphic2, 1.0);
        BandGraphic bandGraphic3 = new BandGraphic(energySection, semiconductorBandSet.getBottomBand(), modelViewTransform2D);
        this.graphic.addGraphic(bandGraphic3, 1.0);
        BandGraphic bandGraphic4 = new BandGraphic(energySection, semiconductorBandSet.getTopBand(), modelViewTransform2D);
        this.graphic.addGraphic(bandGraphic4, 1.0);
        this.graphic.addGraphic(this.backgroundWhite, -1.0);
        this.graphic.addGraphic(this.backgroundBorder, 3.0);
        this.chargeCountGraphic = new ChargeCountGraphic(energySection, this, modelViewTransform2D);
    }

    public void update() {
    }

    public void paint(Graphics2D graphics2D) {
        this.clipGraphic.paint(graphics2D);
        this.chargeCountGraphic.paint(graphics2D);
        if (this.paintLevelIDs) {
            SemiconductorBandSet.EnergyLevelIterator energyLevelIterator = this.bandSet.energyLevelIterator();
            PhetFont phetFont = new PhetFont(10);
            Color color = Color.black;
            graphics2D.setFont(phetFont);
            graphics2D.setColor(color);
            while (energyLevelIterator.hasNext()) {
                EnergyLevel energyLevel = (EnergyLevel)energyLevelIterator.next();
                Rectangle2D.Double double_ = energyLevel.getRegion().toRectangle();
                Vector2D vector2D = RectangleUtils.getCenter(double_);
                Point point = this.getTransform().modelToView(vector2D);
                graphics2D.drawString(energyLevel.getID() + "", point.x, point.y);
            }
        }
    }

    public Rectangle2D.Double getViewport() {
        return this.viewport;
    }

    public Vector2D getViewportBottomCenter() {
        return new Vector2D(this.getViewport().getX() + this.getViewport().getWidth() / 2.0, this.getViewport().getY());
    }
}

