/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.macro.energy.bands;

import edu.colorado.phet.semiconductor.macro.energy.bands.Band;
import edu.colorado.phet.semiconductor.macro.energy.bands.EnergyLevel;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;

public class BandSet {
    ArrayList bands = new ArrayList();

    public Rectangle2D.Double getBounds() {
        RectangularShape rectangularShape = null;
        for (int i = 0; i < this.bands.size(); ++i) {
            Band band = (Band)this.bands.get(i);
            Rectangle2D.Double double_ = band.getRegion().toRectangle();
            if (rectangularShape == null) {
                rectangularShape = double_;
                continue;
            }
            ((Rectangle2D)rectangularShape).add(double_);
        }
        return new Rectangle2D.Double(rectangularShape.getX(), rectangularShape.getY(), rectangularShape.getWidth(), rectangularShape.getHeight());
    }

    public double getX() {
        return this.bandAt(0).getRegion().getMinX();
    }

    public double getWidth() {
        return this.bandAt(0).getRegion().getSpatialWidth();
    }

    public int numBands() {
        return this.bands.size();
    }

    public Band bandAt(int n) {
        return (Band)this.bands.get(n);
    }

    public EnergyLevel levelAt(int n) {
        int n2 = n;
        for (int i = 0; i < this.numBands(); ++i) {
            Band band = this.bandAt(i);
            if (n2 < band.numEnergyLevels()) {
                return band.energyLevelAt(n2);
            }
            n2 -= band.numEnergyLevels();
        }
        return null;
    }

    public int absoluteIndexOf(EnergyLevel energyLevel) {
        for (int i = 0; i < this.numEnergyLevels(); ++i) {
            if (this.levelAt(i) != energyLevel) continue;
            return i;
        }
        return -1;
    }

    public int numEnergyLevels() {
        int n = 0;
        for (int i = 0; i < this.numBands(); ++i) {
            n += this.bandAt(i).numEnergyLevels();
        }
        return n;
    }
}

