/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.macro.energy.bands;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.util.SimpleObservable;
import edu.colorado.phet.semiconductor.macro.energy.bands.Band;
import edu.colorado.phet.semiconductor.macro.energy.bands.BandParticleState;
import edu.colorado.phet.semiconductor.macro.energy.bands.EnergyCell;
import edu.colorado.phet.semiconductor.macro.energy.bands.EnergyLevel;
import edu.colorado.phet.semiconductor.macro.energy.bands.SemiconductorBandSet;
import edu.colorado.phet.semiconductor.macro.energy.states.Waiting;

public class BandParticle
extends SimpleObservable
implements ModelElement {
    double x;
    double y;
    private EnergyCell cell;
    private BandParticleState state;
    static int static_index = 0;
    private int index;
    private boolean excited;
    private Vector2D lastPosition = new Vector2D();

    public BandParticle(double d, double d2, EnergyCell energyCell) {
        this.x = d;
        this.y = d2;
        this.setEnergyCell(energyCell);
        this.state = new Waiting();
        this.index = static_index++;
        this.lastPosition = this.getPosition();
    }

    public BandParticle(double d, double d2) {
        this(d, d2, null);
    }

    public BandParticle(EnergyCell energyCell) {
        this(energyCell.getX(), energyCell.getEnergy(), energyCell);
    }

    public BandParticle(Vector2D vector2D) {
        this(vector2D.getX(), vector2D.getY());
    }

    public int getIndex() {
        return this.index;
    }

    public String toString() {
        return this.getIndex() + "";
    }

    public Vector2D getPosition() {
        return new Vector2D(this.x, this.y);
    }

    public boolean isExcited() {
        return this.excited;
    }

    public void setEnergyCell(EnergyCell energyCell) {
        this.cell = energyCell;
    }

    public EnergyCell getEnergyCell() {
        return this.cell;
    }

    public EnergyLevel getEnergyLevel() {
        if (this.cell == null) {
            return null;
        }
        return this.cell.getEnergyLevel();
    }

    public void stepInTime(double d) {
        this.lastPosition = this.getPosition();
        boolean bl = this.state.stepInTime(this, d);
        if (bl) {
            this.state = new Waiting();
        }
    }

    public void setPosition(Vector2D vector2D) {
        this.x = vector2D.getX();
        this.y = vector2D.getY();
        this.notifyObservers();
    }

    public double getDistanceFromOwnedSite() {
        if (this.cell == null) {
            return Double.POSITIVE_INFINITY;
        }
        Vector2D vector2D = this.cell.getPosition();
        return this.getPosition().getSubtractedInstance(vector2D).getMagnitude();
    }

    public double getY() {
        return this.y;
    }

    public BandParticleState getState() {
        return this.state;
    }

    public void setState(BandParticleState bandParticleState) {
        this.state = bandParticleState;
    }

    public boolean isLocatedAtCell() {
        if (this.cell == null) {
            return false;
        }
        double d = this.getDistanceFromOwnedSite();
        return d <= 1.0E-6;
    }

    public void setExcited(boolean bl) {
        this.excited = bl;
    }

    public SemiconductorBandSet getBandSet() {
        if (this.getEnergyCell() == null) {
            return null;
        }
        return this.getEnergyLevel().getBand().getBandSet();
    }

    public Band getBand() {
        if (this.getEnergyLevel() == null) {
            return null;
        }
        return this.getEnergyLevel().getBand();
    }

    public ImmutableVector2D getDX() {
        return this.getPosition().getSubtractedInstance(this.lastPosition);
    }
}

