/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.macro.energy;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.semiconductor.macro.doping.DopantType;
import edu.colorado.phet.semiconductor.macro.energy.DefaultStateDiagram;
import edu.colorado.phet.semiconductor.macro.energy.EnergySection;
import edu.colorado.phet.semiconductor.macro.energy.bands.Band;
import edu.colorado.phet.semiconductor.macro.energy.bands.BandParticle;
import edu.colorado.phet.semiconductor.macro.energy.bands.EnergyCell;
import edu.colorado.phet.semiconductor.macro.energy.bands.EnergyLevel;
import edu.colorado.phet.semiconductor.macro.energy.bands.SemiconductorBandSet;
import edu.colorado.phet.semiconductor.macro.energy.transitions.ExitLeft;
import edu.colorado.phet.semiconductor.macro.energy.transitions.Move;

class PNPLeftClear
extends DefaultStateDiagram {
    private ModelElement npForward;

    public PNPLeftClear(EnergySection energySection, ModelElement modelElement) {
        super(energySection);
        this.npForward = modelElement;
    }

    public void stepInTime(double d) {
        boolean bl = this.doClear(d);
        if (bl) {
            this.npForward.stepInTime(d);
        }
    }

    private boolean doClear(double d) {
        SemiconductorBandSet semiconductorBandSet = this.getEnergySection().bandSetAt(0);
        Band band = semiconductorBandSet.bandAt(DopantType.P.getDopingBand());
        boolean bl = true;
        for (int i = band.numEnergyLevels() - 1; i >= DopantType.P.getNumFilledLevels(); --i) {
            EnergyLevel energyLevel = band.energyLevelAt(i);
            EnergyCell energyCell = energyLevel.cellAt(0);
            EnergyCell energyCell2 = energyLevel.cellAt(1);
            BandParticle bandParticle = this.getEnergySection().getBandParticle(energyCell);
            BandParticle bandParticle2 = this.getEnergySection().getBandParticle(energyCell2);
            if (bandParticle != null || bandParticle2 != null) {
                bl = false;
            }
            if (bandParticle != null) {
                ExitLeft exitLeft = new ExitLeft();
                exitLeft.apply(bandParticle, this.getEnergySection());
                break;
            }
            if (bandParticle2 == null) continue;
            Move move = new Move(energyCell2, energyCell, this.getSpeed());
            move.apply(bandParticle2, this.getEnergySection());
            break;
        }
        return bl;
    }
}

