/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.macro.energy;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.semiconductor.macro.doping.DopantType;
import edu.colorado.phet.semiconductor.macro.energy.DefaultStateDiagram;
import edu.colorado.phet.semiconductor.macro.energy.DepleteRight;
import edu.colorado.phet.semiconductor.macro.energy.EnergySection;
import edu.colorado.phet.semiconductor.macro.energy.PNForwardClear;
import edu.colorado.phet.semiconductor.macro.energy.bands.EnergyCell;
import edu.colorado.phet.semiconductor.macro.energy.statemodels.Entrance;
import edu.colorado.phet.semiconductor.macro.energy.statemodels.ExciteForConduction;
import edu.colorado.phet.semiconductor.macro.energy.statemodels.ModelCriteria;
import edu.colorado.phet.semiconductor.macro.energy.statemodels.TypeCriteria;
import edu.colorado.phet.semiconductor.macro.energy.transitions.Move;

public class PNHandler
implements ModelElement,
ModelCriteria {
    private EnergySection energySection;
    private DefaultStateDiagram pnBackBias;
    private ModelElement pnForwardBias;
    private ModelElement pnForwardClear;
    private PNForwardClear pnClearAll;

    public PNHandler(EnergySection energySection) {
        this.energySection = energySection;
        this.pnBackBias = new DefaultStateDiagram(energySection);
        ExciteForConduction exciteForConduction = this.pnBackBias.exciteN(2, 1);
        this.pnBackBias.exitRight(exciteForConduction.getRightCell());
        this.pnBackBias.addDepleteRight(2);
        this.pnBackBias.addFillLeft(1);
        this.pnBackBias.move(exciteForConduction.getLeftCell(), exciteForConduction.getRightCell(), energySection.getSpeed());
        this.pnBackBias.addModelElement(new DepleteRight(1, 2, energySection));
        this.pnBackBias.move(energySection.getLeftNeighbor(exciteForConduction.getLeftCell()), exciteForConduction.getLeftCell(), energySection.getSpeed());
        this.pnForwardBias = this.getPNForward();
        this.pnForwardClear = new PNForwardClear(energySection, this.pnForwardBias);
        DefaultStateDiagram defaultStateDiagram = new DefaultStateDiagram(energySection);
        EnergyCell energyCell = energySection.bandSetAt(0).bandAt(1).energyLevelAt(DopantType.P.getNumFilledLevels()).cellAt(0);
        Entrance entrance = defaultStateDiagram.enter(energyCell);
        defaultStateDiagram.moveRight(entrance.getCell());
        this.pnClearAll = new PNForwardClear(energySection, defaultStateDiagram);
        this.pnClearAll.setTopLevel(DopantType.P.getNumFilledLevels() + 1);
        Entrance entrance2 = this.pnClearAll.enter(energySection.getLowerNeighbor(energyCell));
        Move move = this.pnClearAll.move(entrance2.getCell(), energySection.getRightNeighbor(entrance2.getCell()), energySection.getSpeed());
        this.pnClearAll.unexcite(move.getDst().getEnergyLevel());
        EnergyCell energyCell2 = energySection.bandSetAt(0).bandAt(2).energyLevelAt(DopantType.N.getNumFilledLevels()).cellAt(1);
        Move move2 = this.pnClearAll.propagateRight(energyCell2);
        this.pnClearAll.exitRight(move2.getDst());
    }

    private ModelElement getPNForward() {
        DefaultStateDiagram defaultStateDiagram = new DefaultStateDiagram(this.energySection);
        ExciteForConduction exciteForConduction = defaultStateDiagram.exciteN(2, 1);
        ExciteForConduction exciteForConduction2 = defaultStateDiagram.exciteP(1, 0);
        defaultStateDiagram.enter(exciteForConduction.getRightCell());
        defaultStateDiagram.moveLeft(exciteForConduction.getRightCell());
        Move move = defaultStateDiagram.moveLeft(exciteForConduction.getLeftCell());
        defaultStateDiagram.move(move.getDst(), exciteForConduction2.getRightCell(), this.energySection.getFallSpeed());
        defaultStateDiagram.move(exciteForConduction2.getRightCell(), exciteForConduction2.getLeftCell(), this.energySection.getSpeed());
        defaultStateDiagram.exitLeft(exciteForConduction2.getLeftCell());
        return defaultStateDiagram;
    }

    public void stepInTime(double d) {
        if (this.energySection.getVoltage() > 0.0) {
            this.pnBackBias.stepInTime(d);
        } else if (this.energySection.getVoltage() < -0.4) {
            this.pnForwardClear.stepInTime(d);
        } else {
            this.pnClearAll.stepInTime(d);
        }
    }

    public boolean isApplicable(EnergySection energySection) {
        return new TypeCriteria(DopantType.P, DopantType.N).isApplicable(energySection);
    }
}

